/*
 * Decompiled with CFR 0.152.
 */
package org.unifiedpush.android.embedded_fcm_distributor;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.unifiedpush.android.embedded_fcm_distributor.FailedReason;
import org.unifiedpush.android.embedded_fcm_distributor.Gateway;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004J&\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J(\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004J&\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006 "}, d2={"Lorg/unifiedpush/android/embedded_fcm_distributor/Utils;", "", "()V", "getEndpoint", "", "context", "Landroid/content/Context;", "token", "getResolveInfo", "", "Landroid/content/pm/ResolveInfo;", "action", "registerFCM", "", "channelId", "vapid", "useGateway", "", "saveEndpoint", "gateway", "Lorg/unifiedpush/android/embedded_fcm_distributor/Gateway;", "sendMessage", "message", "", "messageId", "sendNewEndpoint", "connectionToken", "fcmToken", "sendRegistrationFailed", "reason", "Lorg/unifiedpush/android/embedded_fcm_distributor/FailedReason;", "sendUnregistered", "embedded_fcm_distributor_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final void sendNewEndpoint(@NotNull Context context, @NotNull String connectionToken, @NotNull String fcmToken, boolean useGateway) {
        String string;
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectionToken, (String)"connectionToken");
        Intrinsics.checkNotNullParameter((Object)fcmToken, (String)"fcmToken");
        Intent $this$sendNewEndpoint_u24lambda_u240 = intent = new Intent();
        boolean bl = false;
        $this$sendNewEndpoint_u24lambda_u240.setPackage(context.getPackageName());
        $this$sendNewEndpoint_u24lambda_u240.setAction("org.unifiedpush.android.connector.NEW_ENDPOINT");
        if (useGateway) {
            string = INSTANCE.getEndpoint(context, fcmToken);
        } else {
            String string2 = "https://fcm.googleapis.com/fcm/send/%s";
            Object[] objectArray = new Object[]{fcmToken};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        }
        String endpoint = string;
        $this$sendNewEndpoint_u24lambda_u240.putExtra("endpoint", endpoint);
        $this$sendNewEndpoint_u24lambda_u240.putExtra("token", connectionToken);
        Intent intent2 = intent;
        context.sendBroadcast(intent2);
    }

    public final void sendUnregistered(@NotNull Context context, @NotNull String token) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intent $this$sendUnregistered_u24lambda_u241 = intent = new Intent();
        boolean bl = false;
        $this$sendUnregistered_u24lambda_u241.setPackage(context.getPackageName());
        $this$sendUnregistered_u24lambda_u241.setAction("org.unifiedpush.android.connector.UNREGISTERED");
        $this$sendUnregistered_u24lambda_u241.putExtra("token", token);
        Intent intent2 = intent;
        context.sendBroadcast(intent2);
    }

    public final void sendRegistrationFailed(@NotNull Context context, @NotNull String connectionToken, @NotNull FailedReason reason) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectionToken, (String)"connectionToken");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        Intent $this$sendRegistrationFailed_u24lambda_u242 = intent = new Intent();
        boolean bl = false;
        $this$sendRegistrationFailed_u24lambda_u242.setPackage(context.getPackageName());
        $this$sendRegistrationFailed_u24lambda_u242.setAction("org.unifiedpush.android.connector.REGISTRATION_FAILED");
        $this$sendRegistrationFailed_u24lambda_u242.putExtra("token", connectionToken);
        $this$sendRegistrationFailed_u24lambda_u242.putExtra("reason", reason.name());
        Intent intent2 = intent;
        context.sendBroadcast(intent2);
    }

    public final void sendMessage(@NotNull Context context, @NotNull String token, @NotNull byte[] message, @Nullable String messageId) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intent $this$sendMessage_u24lambda_u244 = intent = new Intent();
        boolean bl = false;
        $this$sendMessage_u24lambda_u244.setAction("org.unifiedpush.android.connector.MESSAGE");
        $this$sendMessage_u24lambda_u244.setPackage(context.getPackageName());
        $this$sendMessage_u24lambda_u244.putExtra("bytesMessage", message);
        $this$sendMessage_u24lambda_u244.putExtra("token", token);
        String string = messageId;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$sendMessage_u24lambda_u244.putExtra("id", messageId);
        }
        Intent intent2 = intent;
        context.sendBroadcast(intent2);
    }

    public final void registerFCM(@NotNull Context context, @NotNull String channelId, @NotNull String vapid, boolean useGateway) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)vapid, (String)"vapid");
        String subtype = "wp:" + channelId;
        String kid = useGateway ? "1:" + channelId : "0:" + channelId;
        Intent $this$registerFCM_u24lambda_u245 = intent = new Intent("com.google.iid.TOKEN_REQUEST");
        boolean bl = false;
        $this$registerFCM_u24lambda_u245.setPackage("com.google.android.gms");
        $this$registerFCM_u24lambda_u245.putExtra("scope", "GCM");
        $this$registerFCM_u24lambda_u245.putExtra("sender", vapid);
        $this$registerFCM_u24lambda_u245.putExtra("subscription", vapid);
        $this$registerFCM_u24lambda_u245.putExtra("X-subscription", vapid);
        $this$registerFCM_u24lambda_u245.putExtra("subtype", subtype);
        $this$registerFCM_u24lambda_u245.putExtra("X-subtype", subtype);
        $this$registerFCM_u24lambda_u245.putExtra("kid", kid);
        $this$registerFCM_u24lambda_u245.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)0x4000000));
        Intent intent2 = intent;
        context.sendBroadcast(intent2);
    }

    public final void saveEndpoint(@NotNull Context context, @NotNull Gateway gateway) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        context.getSharedPreferences("UP-embedded_fcm", 0).edit().putString("UP-embedded_fcm:endpoint", gateway.getEndpoint("%s")).apply();
    }

    private final String getEndpoint(Context context, String token) {
        String string;
        String string2 = context.getSharedPreferences("UP-embedded_fcm", 0).getString("UP-embedded_fcm:endpoint", null);
        if (string2 != null) {
            String string3 = string2;
            Object[] objectArray = new Object[]{token};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final List<ResolveInfo> getResolveInfo(@NotNull Context context, @NotNull String action) {
        List list;
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intent $this$getResolveInfo_u24lambda_u246 = intent = new Intent(action);
        boolean bl = false;
        $this$getResolveInfo_u24lambda_u246.setPackage(context.getPackageName());
        Intent intent2 = intent;
        if (Build.VERSION.SDK_INT >= 33) {
            List list2 = context.getPackageManager().queryBroadcastReceivers(intent2, PackageManager.ResolveInfoFlags.of((long)192L));
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n                    co\u2026      )\n                }");
        } else {
            List list3 = context.getPackageManager().queryBroadcastReceivers(new Intent("org.unifiedpush.android.distributor.REGISTER"), 64);
            list = list3;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"{\n                    co\u2026      )\n                }");
        }
        return list;
    }
}

