/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.locator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.unitils.core.UnitilsException;

public abstract class ClassPathResourceLocator {
    private static Log logger = LogFactory.getLog(ClassPathResourceLocator.class);
    protected List<URL> resourceList;

    public List<URL> loadResources(String path, Boolean isConcreteResource) {
        this.resourceList = new ArrayList<URL>();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                this.resourceList.add(url);
                logger.debug((Object)(" Resource '" + url.toString() + "' added to resourcelist "));
                if (isConcreteResource.booleanValue()) continue;
                List<URL> subResources = this.searchResources(url);
                this.resourceList.addAll(subResources);
            }
        }
        catch (IOException e) {
            throw new UnitilsException("Unable to scan for resources in path " + path + "", (Throwable)e);
        }
        return this.resourceList;
    }

    protected List<URL> searchResources(URL url) throws IOException {
        PathMatchingResourcePatternResolver p = new PathMatchingResourcePatternResolver();
        Resource[] scriptResources = p.getResources(url.toString() + "**");
        ArrayList<URL> listScriptResources = new ArrayList<URL>();
        for (int i = 0; i < scriptResources.length; ++i) {
            URL urlResource = scriptResources[i].getURL();
            listScriptResources.add(urlResource);
            logger.debug((Object)(" Resource '" + urlResource.toString() + "' added to resourcelist "));
        }
        return listScriptResources;
    }
}

