/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.structure.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.IncludeTableFilter;
import org.dbunit.dataset.xml.FlatDtdWriter;
import org.unitils.core.UnitilsException;
import org.unitils.dbmaintainer.structure.DataSetStructureGenerator;
import org.unitils.dbmaintainer.util.BaseDatabaseAccessor;
import org.unitils.thirdparty.org.apache.commons.dbutils.DbUtils;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;
import org.unitils.util.PropertyUtils;

public class DtdDataSetStructureGenerator
extends BaseDatabaseAccessor
implements DataSetStructureGenerator {
    public static final String PROPKEY_DTD_FILENAME = "dtdGenerator.dtd.filename";
    private String dtdFileName;

    @Override
    protected void doInit(Properties configuration) {
        this.dtdFileName = PropertyUtils.getString((String)PROPKEY_DTD_FILENAME, (Properties)configuration);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void generateDataSetStructure() {
        FileWriter writer = null;
        try {
            File dtdFile = new File(this.dtdFileName);
            File parentDirectory = dtdFile.getParentFile();
            if (parentDirectory == null) {
                throw new UnitilsException("Error generating DTD file. Could not find parent directory for DTD file: " + this.dtdFileName);
            }
            parentDirectory.mkdirs();
            String dtdContent = this.generateDtdContent();
            dtdContent = StringUtils.replace((String)dtdContent, (String)"#REQUIRED\n", (String)"#IMPLIED\n");
            writer = new FileWriter(dtdFile);
            IOUtils.write((String)dtdContent, (Writer)writer);
        }
        catch (UnitilsException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new UnitilsException("Error generating DTD file: " + this.dtdFileName, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    protected String generateDtdContent() {
        String string;
        Connection conn = null;
        try {
            conn = this.sqlHandler.getDataSource().getConnection();
            DatabaseConnection dbUnitDatabaseConnection = new DatabaseConnection(conn, this.defaultDbSupport.getSchemaName());
            StringWriter stringWriter = new StringWriter();
            FlatDtdWriter datasetWriter = new FlatDtdWriter((Writer)stringWriter);
            datasetWriter.setContentModel(FlatDtdWriter.CHOICE);
            Set tableNames = this.defaultDbSupport.getTableNames();
            IDataSet actualDataSet = dbUnitDatabaseConnection.createDataSet();
            FilteredDataSet filteredActualDataSet = new FilteredDataSet((ITableFilter)new IncludeTableFilter(tableNames.toArray(new String[0])), actualDataSet);
            datasetWriter.write((IDataSet)filteredActualDataSet);
            string = stringWriter.toString();
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error generating content for DTD file.", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Connection)conn);
        return string;
    }
}

