/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.locator;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.dbmaintainer.locator.ClassPathResourceLocator;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.ResourcePickingStrategie;
import org.unitils.dbmaintainer.script.Script;
import org.unitils.dbmaintainer.script.ScriptContentHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathScriptLocator
extends ClassPathResourceLocator {
    private static Log logger = LogFactory.getLog(ClassPathScriptLocator.class);
    protected List<Script> scriptList;
    protected String path;
    protected List<String> scriptExtensions;

    public void loadScripts(List<Script> scriptList1, String path1, ResourcePickingStrategie resourcePickingStrategie, List<String> scriptExtensions1) {
        this.path = path1;
        this.scriptList = scriptList1;
        this.scriptExtensions = scriptExtensions1;
        List<URL> matchedResources = this.loadResources(path1, false);
        List<URL> resourcesF = resourcePickingStrategie.filter(matchedResources, path1);
        try {
            this.addToScriptList(resourcesF);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void addToScriptList(List<URL> resourcesF) throws IOException {
        for (URL url : resourcesF) {
            if (!this.isScriptFile(url.toString())) continue;
            Script script = new Script(url.toString().substring(url.toString().lastIndexOf(this.path) + this.path.length()), (Long)url.openConnection().getLastModified(), new ScriptContentHandle.UrlScriptContentHandle(url));
            logger.debug((Object)(" + script added (" + url.toString() + "))"));
            this.scriptList.add(script);
        }
    }

    protected boolean isScriptFile(String location) {
        String name = location;
        for (String fileExtension : this.scriptExtensions) {
            if (!name.endsWith(fileExtension)) continue;
            return true;
        }
        return false;
    }
}

