/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.dataset.comparison;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.unitils.dbunit.dataset.Row;
import org.unitils.dbunit.dataset.Table;
import org.unitils.dbunit.dataset.comparison.RowDifference;

public class TableDifference {
    private Table table;
    private Table actualTable;
    private List<Row> missingRows = new ArrayList<Row>();
    private Map<Row, RowDifference> bestRowDifferences = new HashMap<Row, RowDifference>();

    public TableDifference(Table table, Table actualTable) {
        this.table = table;
        this.actualTable = actualTable;
    }

    public Table getTable() {
        return this.table;
    }

    public Table getActualTable() {
        return this.actualTable;
    }

    public List<Row> getMissingRows() {
        return this.missingRows;
    }

    public void addMissingRow(Row missingRow) {
        this.missingRows.add(missingRow);
    }

    public List<RowDifference> getBestRowDifferences() {
        return new ArrayList<RowDifference>(this.bestRowDifferences.values());
    }

    public RowDifference getBestRowDifference(Row row) {
        return this.bestRowDifferences.get(row);
    }

    public void setMatchingRow(Row row, Row actualRow) {
        this.bestRowDifferences.remove(row);
        Iterator<RowDifference> iterator = this.bestRowDifferences.values().iterator();
        while (iterator.hasNext()) {
            RowDifference bestRowDifference = iterator.next();
            if (bestRowDifference.getActualRow() != actualRow) continue;
            iterator.remove();
        }
    }

    public void setIfBestRowDifference(RowDifference rowDifference) {
        RowDifference bestRowComparison = this.bestRowDifferences.get(rowDifference.getRow());
        if (bestRowComparison == null || rowDifference.isBetterMatch(bestRowComparison)) {
            this.bestRowDifferences.put(rowDifference.getRow(), rowDifference);
        }
    }

    public boolean isMatch() {
        return this.missingRows.isEmpty() && this.bestRowDifferences.isEmpty();
    }
}

