/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.easymock.util;

import java.util.List;
import org.easymock.IAnswer;
import org.easymock.IArgumentMatcher;
import org.easymock.MockType;
import org.easymock.internal.IMocksControlState;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.MocksControl;
import org.easymock.internal.Range;
import org.easymock.internal.RecordState;
import org.unitils.easymock.util.ReflectionArgumentMatcher;
import org.unitils.reflectionassert.ReflectionComparatorMode;

public class LenientMocksControl
extends MocksControl {
    private static final long serialVersionUID = -4612378998272988410L;
    private InvocationInterceptor invocationInterceptor;

    public LenientMocksControl(ReflectionComparatorMode ... modes) {
        this(MockType.DEFAULT, modes);
    }

    public LenientMocksControl(MockType type, ReflectionComparatorMode ... modes) {
        super(type);
        this.invocationInterceptor = new InvocationInterceptor(modes);
    }

    public IMocksControlState getState() {
        IMocksControlState mocksControlState = super.getState();
        if (mocksControlState instanceof RecordState) {
            this.invocationInterceptor.setRecordState((RecordState)mocksControlState);
            return this.invocationInterceptor;
        }
        return mocksControlState;
    }

    private class InvocationInterceptor
    implements IMocksControlState {
        private RecordState recordState;
        private ReflectionComparatorMode[] modes;

        public InvocationInterceptor(ReflectionComparatorMode ... modes) {
            this.modes = modes;
        }

        public void setRecordState(RecordState recordState) {
            this.recordState = recordState;
        }

        public Object invoke(Invocation invocation) {
            LastControl.reportLastControl((MocksControl)LenientMocksControl.this);
            this.createMatchers(invocation);
            return this.recordState.invoke(invocation);
        }

        private void createMatchers(Invocation invocation) {
            List matchers = LastControl.pullMatchers();
            if (matchers != null && !matchers.isEmpty()) {
                if (matchers.size() != invocation.getArguments().length) {
                    throw new IllegalStateException("This mock control does not support mixing of no-argument matchers and per-argument matchers. Either no matchers are defined and the reflection argument matcher is used by default or all matchers are defined explicitly (Eg by using refEq()).");
                }
                for (IArgumentMatcher matcher : matchers) {
                    LastControl.reportMatcher((IArgumentMatcher)matcher);
                }
                return;
            }
            Object[] arguments = invocation.getArguments();
            if (arguments == null) {
                return;
            }
            for (Object argument : arguments) {
                LastControl.reportMatcher(new ReflectionArgumentMatcher<Object>(argument, this.modes));
            }
        }

        public void assertRecordState() {
            this.recordState.assertRecordState();
        }

        public void andReturn(Object value) {
            this.recordState.andReturn(value);
        }

        public void andThrow(Throwable throwable) {
            this.recordState.andThrow(throwable);
        }

        public void andAnswer(IAnswer<?> answer) {
            this.recordState.andAnswer(answer);
        }

        public void andStubReturn(Object value) {
            this.recordState.andStubReturn(value);
        }

        public void andStubThrow(Throwable throwable) {
            this.recordState.andStubThrow(throwable);
        }

        public void andStubAnswer(IAnswer<?> answer) {
            this.recordState.andStubAnswer(answer);
        }

        public void asStub() {
            this.recordState.asStub();
        }

        public void times(Range range) {
            this.recordState.times(range);
        }

        public void checkOrder(boolean value) {
            this.recordState.checkOrder(value);
        }

        public void replay() {
            this.recordState.replay();
        }

        public void verify() {
            this.recordState.verify();
        }

        public void andDelegateTo(Object value) {
            this.recordState.andDelegateTo(value);
        }

        public void andStubDelegateTo(Object value) {
            this.recordState.andStubDelegateTo(value);
        }

        public void checkIsUsedInOneThread(boolean value) {
            this.recordState.checkIsUsedInOneThread(value);
        }

        public void makeThreadSafe(boolean value) {
            this.recordState.makeThreadSafe(value);
        }
    }
}

