/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.io.annotation.handler;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.io.annotation.TempDir;
import org.unitils.io.temp.TempService;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

public class TempDirAnnotationHandler
extends TestListener {
    protected Boolean cleanupAfterTest;
    protected TempService tempService;

    public TempDirAnnotationHandler(TempService tempService, Boolean cleanupAfterTest) {
        this.tempService = tempService;
        this.cleanupAfterTest = cleanupAfterTest;
    }

    public void beforeTestSetUp(Object testObject, Method testMethod) {
        Set tmpFileFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TempDir.class);
        for (Field field : tmpFileFields) {
            this.createTempDirForField(testObject, testMethod, field);
        }
    }

    public void afterTestMethod(Object testObject, Method testMethod, Throwable t) {
        if (!this.cleanupAfterTest.booleanValue()) {
            return;
        }
        Set tmpFileFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TempDir.class);
        for (Field field : tmpFileFields) {
            this.deleteTempDirForField(testObject, field);
        }
    }

    protected void createTempDirForField(Object testObject, Method testMethod, Field field) {
        TempDir annotation = field.getAnnotation(TempDir.class);
        String fileName = annotation.value();
        if (fileName.isEmpty()) {
            fileName = testObject.getClass().getName() + "-" + testMethod.getName();
        }
        try {
            File f = this.tempService.createTempDir(fileName);
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)f);
        }
        catch (Exception e) {
            throw new UnitilsException("Error creating temp dir for field " + field.getName(), (Throwable)e);
        }
    }

    protected void deleteTempDirForField(Object testObject, Field field) {
        try {
            File tempDir = (File)ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
            this.tempService.deleteTempFileOrDir(tempDir);
        }
        catch (Exception e) {
            throw new UnitilsException("Error deleting temp dir for field " + field.getName(), (Throwable)e);
        }
    }
}

