/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core.proxy;

import java.lang.reflect.Method;
import java.util.List;
import org.unitils.mock.core.proxy.CloneUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyInvocation {
    private String mockName;
    private Object proxy;
    private Method method;
    private List<Object> arguments;
    private List<Object> argumentsAtInvocationTime;
    private StackTraceElement[] invokedAtTrace;

    public ProxyInvocation(String mockName, Object proxy, Method method, List<Object> arguments, StackTraceElement[] invokedAtTrace) {
        this.mockName = mockName;
        this.proxy = proxy;
        this.method = method;
        this.arguments = arguments;
        this.argumentsAtInvocationTime = arguments;
        this.invokedAtTrace = invokedAtTrace;
    }

    public ProxyInvocation(ProxyInvocation proxyInvocation) {
        this.mockName = proxyInvocation.getMockName();
        this.proxy = proxyInvocation.getProxy();
        this.method = proxyInvocation.getMethod();
        this.arguments = proxyInvocation.getArguments();
        this.argumentsAtInvocationTime = CloneUtil.createDeepClone(this.arguments);
        this.invokedAtTrace = proxyInvocation.getInvokedAtTrace();
    }

    public Object invokeOriginalBehavior() throws Throwable {
        throw new UnsupportedOperationException("Invoking of original behavior not implemented.");
    }

    public int getNrOfNotNullArguments() {
        if (this.argumentsAtInvocationTime == null) {
            return 0;
        }
        int count = 0;
        for (Object argument : this.argumentsAtInvocationTime) {
            if (argument == null) continue;
            ++count;
        }
        return count;
    }

    public String getMockName() {
        return this.mockName;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public Method getMethod() {
        return this.method;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public List<Object> getArgumentsAtInvocationTime() {
        return this.argumentsAtInvocationTime;
    }

    public StackTraceElement[] getInvokedAtTrace() {
        return this.invokedAtTrace;
    }

    public StackTraceElement getInvokedAt() {
        return this.invokedAtTrace[0];
    }

    public int getLineNumber() {
        return this.getInvokedAt().getLineNumber();
    }
}

