/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core.matching.impl;

import java.util.List;
import org.unitils.mock.Mock;
import org.unitils.mock.argumentmatcher.ArgumentMatcher;
import org.unitils.mock.core.BehaviorDefiningInvocation;
import org.unitils.mock.core.BehaviorDefiningInvocations;
import org.unitils.mock.core.MockFactory;
import org.unitils.mock.core.matching.MatchingInvocationHandler;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.mock.mockbehavior.MockBehavior;
import org.unitils.mock.mockbehavior.impl.ValueReturningMockBehavior;

public class BehaviorDefiningMatchingInvocationHandler
implements MatchingInvocationHandler {
    protected MockBehavior mockBehavior;
    protected MockFactory mockFactory;
    protected BehaviorDefiningInvocations behaviorDefiningInvocations;

    public BehaviorDefiningMatchingInvocationHandler(MockBehavior mockBehavior, BehaviorDefiningInvocations behaviorDefiningInvocations, MockFactory mockFactory) {
        this.mockBehavior = mockBehavior;
        this.behaviorDefiningInvocations = behaviorDefiningInvocations;
        this.mockFactory = mockFactory;
    }

    @Override
    public Object handleInvocation(ProxyInvocation proxyInvocation, List<ArgumentMatcher> argumentMatchers) throws Throwable {
        if (this.mockBehavior instanceof ChainedMockBehavior) {
            ((ChainedMockBehavior)this.mockBehavior).installChain();
        }
        BehaviorDefiningInvocation behaviorDefiningInvocation = new BehaviorDefiningInvocation(proxyInvocation, this.mockBehavior, argumentMatchers);
        this.addBehaviorDefiningInvocation(behaviorDefiningInvocation, this.behaviorDefiningInvocations);
        return this.createChainedMock(proxyInvocation, behaviorDefiningInvocation);
    }

    protected void addBehaviorDefiningInvocation(BehaviorDefiningInvocation behaviorDefiningInvocation, BehaviorDefiningInvocations behaviorDefinition) {
        behaviorDefinition.addBehaviorDefiningInvocation(behaviorDefiningInvocation);
    }

    protected Object createChainedMock(ProxyInvocation proxyInvocation, BehaviorDefiningInvocation behaviorDefiningInvocation) {
        Class<?> innerMockType = proxyInvocation.getMethod().getReturnType();
        String innerMockName = proxyInvocation.getMockName() + "##chained##" + proxyInvocation.getMethod().getName();
        Mock<?> mock = this.mockFactory.createChainedMock(innerMockName, innerMockType);
        if (mock == null) {
            return null;
        }
        return mock.performs(new ChainedMockBehavior(mock, behaviorDefiningInvocation));
    }

    public static class ChainedMockBehavior
    implements MockBehavior {
        protected Mock<?> mock;
        protected BehaviorDefiningInvocation behaviorDefiningInvocation;
        protected MockBehavior originalMockBehavior;

        public ChainedMockBehavior(Mock<?> mock, BehaviorDefiningInvocation behaviorDefiningInvocation) {
            this.mock = mock;
            this.behaviorDefiningInvocation = behaviorDefiningInvocation;
            this.originalMockBehavior = behaviorDefiningInvocation.getMockBehavior();
        }

        public void installChain() {
            this.behaviorDefiningInvocation.setMockBehavior(new ValueReturningMockBehavior(this.mock.getMock()));
        }

        @Override
        public Object execute(ProxyInvocation proxyInvocation) throws Throwable {
            return this.originalMockBehavior.execute(proxyInvocation);
        }
    }
}

