/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.command;

import org.unix4j.command.Arguments;
import org.unix4j.command.Command;
import org.unix4j.context.ExecutionContext;
import org.unix4j.processor.LineProcessor;

public class JoinedCommand<A extends Arguments<A>>
implements Command<A> {
    private final Command<A> first;
    private final Command<?> second;

    public JoinedCommand(Command<A> first, Command<?> second) {
        if (first == null) {
            throw new NullPointerException("first command cannot be null");
        }
        if (second == null) {
            throw new NullPointerException("second command cannot be null");
        }
        this.first = first;
        this.second = second;
    }

    public static <A extends Arguments<A>> JoinedCommand<A> join(Command<A> first, Command<?> second) {
        return new JoinedCommand<A>(first, second);
    }

    public Command<A> getFirst() {
        return this.first;
    }

    public Command<?> getSecond() {
        return this.second;
    }

    @Override
    public String getName() {
        return this.getFirst().getName() + " | " + this.getSecond().getName();
    }

    @Override
    public A getArguments(ExecutionContext context) {
        return this.getFirst().getArguments(context);
    }

    @Override
    public Command<?> join(Command<?> next) {
        return JoinedCommand.join(this.getFirst(), this.getSecond().join(next));
    }

    @Override
    public LineProcessor execute(ExecutionContext context, LineProcessor output) {
        return this.getFirst().execute(context, this.getSecond().execute(context, output));
    }

    @Override
    public String toString() {
        return this.first + " | " + this.second;
    }
}

