/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.convert;

import org.unix4j.convert.ValueConverter;

public class ConcatenatedConverter<V>
implements ValueConverter<V> {
    private final ValueConverter<?> first;
    private final ValueConverter<V> second;

    public ConcatenatedConverter(ValueConverter<?> sourceConverter, ValueConverter<V> targetConverter) {
        this.first = sourceConverter;
        this.second = targetConverter;
    }

    public static <V> ConcatenatedConverter<V> concat(ValueConverter<?> first, ValueConverter<V> second) {
        return new ConcatenatedConverter<V>(first, second);
    }

    public <N> ConcatenatedConverter<N> concat(ValueConverter<N> next) {
        return ConcatenatedConverter.concat(this, next);
    }

    @Override
    public V convert(Object value) throws IllegalArgumentException {
        Object source = this.first.convert(value);
        return this.second.convert(source);
    }
}

