/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.io;

import java.util.Arrays;
import java.util.List;
import org.unix4j.io.AbstractInput;
import org.unix4j.io.Input;
import org.unix4j.line.Line;

public class CompositeInput
extends AbstractInput {
    private int index;
    private final List<? extends Input> inputs;

    public CompositeInput(Input ... inputs) {
        this(Arrays.asList(inputs));
    }

    public CompositeInput(List<? extends Input> inputs) {
        this.inputs = inputs;
    }

    @Override
    public boolean hasMoreLines() {
        while (this.index < this.inputs.size()) {
            if (this.inputs.get(this.index).hasMoreLines()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    @Override
    public Line readLine() {
        if (this.hasMoreLines()) {
            return this.inputs.get(this.index).readLine();
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(inputs=" + this.inputs + ")";
    }
}

