/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.unix4j.util.OS;
import org.unix4j.util.RelativePathBase;
import org.unix4j.variable.Arg;

public class FileUtil {
    public static final String ROOT_UNIX = "/";
    public static final String ROOT_WINDOWS = "C:\\";
    public static final String ROOT_WINDOWS_NETWORK = "\\\\";
    public static final String ROOT = FileUtil.isWindows() ? "C:\\" : "/";

    private static boolean isWindows() {
        return OS.Windows.equals((Object)OS.current());
    }

    public static File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static List<File> toList(File ... files) {
        ArrayList<File> list = new ArrayList<File>(files.length + 2);
        for (int i = 0; i < files.length; ++i) {
            list.add(files[i]);
        }
        return list;
    }

    public static String getRelativePath(File root, File file) {
        return new RelativePathBase(root).getRelativePathFor(file);
    }

    public static File toAbsoluteFile(File currentDirectory, File file) {
        if (file.isAbsolute() || Arg.isVariable(file.getPath())) {
            return file;
        }
        if (currentDirectory == null) {
            return file.getAbsoluteFile();
        }
        return new File(currentDirectory, file.getPath()).getAbsoluteFile();
    }

    public static List<String> getPathElements(File file) {
        file = file.getAbsoluteFile();
        LinkedList<String> elements = new LinkedList<String>();
        do {
            elements.add(0, file.getName());
        } while ((file = file.getParentFile()) != null);
        elements.remove(0);
        return elements;
    }

    public static List<File> expandFiles(String ... paths) {
        return FileUtil.expandFiles(FileUtil.getUserDir(), paths);
    }

    public static List<File> expandFiles(File currentDirectory, String ... paths) {
        ArrayList<File> expanded = new ArrayList<File>(paths.length);
        for (String path : paths) {
            FileUtil.addFileExpanded(currentDirectory, new File(path), expanded);
        }
        return expanded;
    }

    private static void addFileExpanded(File currentDirectory, File file, List<File> expandedFiles) {
        if (!file.isAbsolute()) {
            file = new File(currentDirectory, file.getPath());
        }
        if (FileUtil.isWildcardFileName(file.getPath())) {
            File p;
            LinkedList<String> parts = new LinkedList<String>();
            File f = file;
            do {
                parts.add(0, f.getName());
                p = f;
            } while ((f = f.getParentFile()) != null);
            if (p.isDirectory()) {
                parts.remove(0);
            } else if (p.getPath().endsWith("\\")) {
                parts.remove(0);
            }
            while (!parts.isEmpty() && !FileUtil.isWildcardFileName((String)parts.get(0))) {
                p = new File(p, (String)parts.remove(0));
            }
            if (!p.isDirectory()) {
                throw new IllegalArgumentException("file not found: " + file + " [root=" + p + ", currentDirectory=" + currentDirectory + "]");
            }
            FileUtil.listFiles(p, parts, expandedFiles);
        } else if (file.exists()) {
            expandedFiles.add(file);
        } else {
            File relFile = new File(currentDirectory, file.getPath());
            if (relFile.exists()) {
                expandedFiles.add(relFile);
            } else {
                throw new IllegalArgumentException("file not found: " + file + " [currentDirectory=" + currentDirectory + "]");
            }
        }
    }

    private static void listFiles(File file, List<String> parts, List<File> dest) {
        String part = parts.remove(0);
        FilenameFilter filter = FileUtil.getFileNameFilter(part);
        for (File f : file.listFiles(filter)) {
            if (parts.isEmpty()) {
                dest.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            FileUtil.listFiles(f, parts, dest);
        }
        parts.add(0, part);
    }

    public static FilenameFilter getFileNameFilter(String name) {
        if (FileUtil.isWildcardFileName(name)) {
            if (FileUtil.isWindows()) {
                name = name.replace("%%", "%_");
                name = name.replace("%.", "%/").replace(".", "\\.").replace("%/", "\\.");
                name = name.replace("%*", "%/").replace("*", ".*").replace("%/", "\\*");
                name = name.replace("%?", "%/").replace("?", ".").replace("%/", "\\?");
                name = name.replace("%_", "%");
            } else {
                name = name.replace(ROOT_WINDOWS_NETWORK, "\\_");
                name = name.replace("\\.", "\\/").replace(".", "\\.").replace("\\/", "\\.");
                name = name.replace("\\*", "\\/").replace("*", ".*").replace("\\/", "\\*");
                name = name.replace("\\?", "\\/").replace("?", ".").replace("\\/", "\\?");
                name = name.replace("\\_", ROOT_WINDOWS_NETWORK);
            }
            final Pattern pattern = Pattern.compile(name);
            return new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return pattern.matcher(name).matches();
                }
            };
        }
        final String fileName = name;
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return fileName.equals(name);
            }
        };
    }

    public static boolean isWildcardFileName(String name) {
        if (name.contains("*") || name.contains("?")) {
            String unescaped = FileUtil.isWindows() ? name.replace("%%", "%_").replace("%*", "%_").replace("%?", "%_") : name.replace(ROOT_WINDOWS_NETWORK, "\\_").replace("\\*", "\\_").replace("\\?", "\\_");
            return unescaped.contains("*") || unescaped.contains("?");
        }
        return false;
    }

    public static File getOutputDirectoryGivenClass(Class<?> clazz) {
        File parentDir = FileUtil.getDirectoryOfClassFile(clazz);
        int packageDepth = clazz.getName().split("\\.").length;
        for (int i = 0; i < packageDepth - 1; ++i) {
            parentDir = parentDir.getParentFile();
        }
        return parentDir;
    }

    public static File getDirectoryOfClassFile(Class<?> clazz) {
        String resource = ROOT_UNIX + clazz.getName().replace(".", ROOT_UNIX) + ".class";
        URL classFileURL = clazz.getResource(resource);
        File classFile = new File(classFileURL.getFile());
        return classFile.getParentFile();
    }

    public static File getDirectoryOfClassFile(String className) {
        String resource = ROOT_UNIX + className.replace(".", ROOT_UNIX) + ".class";
        URL classFileURL = FileUtil.class.getResource(resource);
        File classFile = new File(classFileURL.getFile());
        return classFile.getParentFile();
    }

    private FileUtil() {
    }
}

