/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.variable;

import java.util.LinkedHashMap;
import org.unix4j.context.ExecutionContext;
import org.unix4j.variable.VariableResolver;

public class ExecutionContextVariableResolver
implements VariableResolver {
    private final ExecutionContext executionContext;

    public ExecutionContextVariableResolver(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public Object getValue(String name) {
        Variable variable = Variable.getByVariableName(name);
        if (variable != null) {
            return variable.getValue(this.executionContext);
        }
        return null;
    }

    public String toString() {
        LinkedHashMap<Variable, Object> map = new LinkedHashMap<Variable, Object>();
        for (Variable v : Variable.values()) {
            map.put(v, v.getValue(this.executionContext));
        }
        return ((Object)map).toString();
    }

    public static enum Variable {
        CurrentDirectory("$pwd"){

            @Override
            public Object getValue(ExecutionContext executionContext) {
                return executionContext.getCurrentDirectory();
            }
        }
        ,
        User("$whoami"){

            @Override
            public Object getValue(ExecutionContext executionContext) {
                return executionContext.getUser();
            }
        }
        ,
        UserHome("$home"){

            @Override
            public Object getValue(ExecutionContext executionContext) {
                return executionContext.getUserHome();
            }
        }
        ,
        TempDirectory("$temp"){

            @Override
            public Object getValue(ExecutionContext executionContext) {
                return executionContext.getTempDirectory();
            }
        }
        ,
        Locale("$locale"){

            @Override
            public Object getValue(ExecutionContext executionContext) {
                return executionContext.getLocale();
            }
        };

        private final String unixName;

        private Variable(String unixName) {
            this.unixName = unixName;
        }

        public String getUnixName() {
            return this.unixName;
        }

        public static Variable getByVariableName(String variableName) {
            for (Variable v : Variable.values()) {
                if (!v.getUnixName().equals(variableName)) continue;
                return v;
            }
            return null;
        }

        public abstract Object getValue(ExecutionContext var1);
    }
}

