/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.builder;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.unix4j.builder.CommandBuilder;
import org.unix4j.command.Command;
import org.unix4j.command.ExitValueException;
import org.unix4j.command.NoOp;
import org.unix4j.context.DefaultExecutionContext;
import org.unix4j.context.ExecutionContextFactory;
import org.unix4j.io.BufferedOutput;
import org.unix4j.io.FileOutput;
import org.unix4j.io.NullOutput;
import org.unix4j.io.Output;
import org.unix4j.io.StdOutput;
import org.unix4j.io.StreamOutput;
import org.unix4j.io.StringOutput;
import org.unix4j.io.WriterOutput;
import org.unix4j.line.Line;
import org.unix4j.operation.AdHocCommand;
import org.unix4j.operation.LineOperation;

public class DefaultCommandBuilder
implements CommandBuilder {
    private final ExecutionContextFactory contextFactory;
    private Command<?> command = NoOp.INSTANCE;

    public DefaultCommandBuilder() {
        this(DefaultExecutionContext.FACTORY);
    }

    public DefaultCommandBuilder(ExecutionContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public ExecutionContextFactory getContextFactory() {
        return this.contextFactory;
    }

    @Override
    public CommandBuilder join(Command<?> command) {
        if (command == null) {
            throw new NullPointerException("command argument cannot be null");
        }
        this.command = this.command.join(command);
        return this;
    }

    @Override
    public CommandBuilder apply(LineOperation operation) {
        return this.join(new AdHocCommand(operation));
    }

    @Override
    public CommandBuilder reset() {
        this.command = NoOp.INSTANCE;
        return this;
    }

    @Override
    public Command<?> build() {
        return this.command;
    }

    @Override
    public String toString() {
        return this.command.toString();
    }

    @Override
    public void toStdOut() {
        this.toOutput(new StdOutput());
    }

    @Override
    public List<Line> toLineList() {
        ArrayList<Line> lines = new ArrayList<Line>();
        this.toOutput(new BufferedOutput(lines));
        return lines;
    }

    @Override
    public List<String> toStringList() {
        final ArrayList<String> lines = new ArrayList<String>();
        this.toOutput(new Output(){

            @Override
            public boolean processLine(Line line) {
                lines.add(line.getContent());
                return true;
            }

            @Override
            public void finish() {
            }
        });
        return lines;
    }

    @Override
    public Stream<Line> toLineStream() {
        return this.toLineList().stream();
    }

    @Override
    public Stream<String> toStringStream() {
        return this.toStringList().stream();
    }

    @Override
    public void toOutput(Output output) {
        Command<?> command = this.build();
        command.execute(this.getContextFactory().createExecutionContext(), output).finish();
    }

    @Override
    public void toFile(String file) {
        this.toFile(new File(file));
    }

    @Override
    public void toFile(File file) {
        this.toOutput(new FileOutput(file));
    }

    @Override
    public void toOutputStream(OutputStream stream) {
        this.toOutput(new StreamOutput(stream));
    }

    @Override
    public void toWriter(Writer writer) {
        this.toOutput(new WriterOutput(writer));
    }

    @Override
    public void toDevNull() {
        this.toOutput(NullOutput.DEFAULT);
    }

    @Override
    public String toStringResult() {
        StringOutput out = new StringOutput();
        this.toOutput(out);
        return out.toString();
    }

    @Override
    public int toExitValue() {
        try {
            this.toDevNull();
            return 0;
        }
        catch (ExitValueException e) {
            return e.getExitValue();
        }
    }
}

