/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.convert;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.unix4j.convert.CompositeValueConverter;
import org.unix4j.convert.ConcatenatedConverter;
import org.unix4j.convert.ValueConverter;

public class ListConverters {
    public static final ValueConverter<List<?>> COLLECTION_TO_LIST = new ValueConverter<List<?>>(){

        @Override
        public List<?> convert(Object value) throws IllegalArgumentException {
            if (value instanceof Collection) {
                if (value instanceof List) {
                    return (List)value;
                }
                return new ArrayList((Collection)value);
            }
            return null;
        }
    };
    public static final ValueConverter<List<Object>> OBJECT_ARRAY_TO_LIST = new ValueConverter<List<Object>>(){

        @Override
        public List<Object> convert(Object value) throws IllegalArgumentException {
            if (value instanceof Object[]) {
                return Arrays.asList((Object[])value);
            }
            return null;
        }
    };
    public static final ValueConverter<List<Object>> ANY_ARRAY_TO_LIST = new ValueConverter<List<Object>>(){

        @Override
        public List<Object> convert(Object value) throws IllegalArgumentException {
            if (value != null && value.getClass().isArray()) {
                int len = Array.getLength(value);
                ArrayList<Object> result = new ArrayList<Object>(len);
                for (int i = 0; i < len; ++i) {
                    Object element = Array.get(value, i);
                    result.add(element);
                }
                return result;
            }
            return null;
        }
    };
    public static final ValueConverter<List<Object>> ARRAY_TO_LIST = new CompositeValueConverter<List<Object>>().add(OBJECT_ARRAY_TO_LIST).add(ANY_ARRAY_TO_LIST);
    public static final ValueConverter<List<Object>> OBJECT_TO_SINGLETON_LIST = new ValueConverter<List<Object>>(){

        @Override
        public List<Object> convert(Object value) throws IllegalArgumentException {
            if (value != null) {
                return Collections.singletonList(value);
            }
            return null;
        }
    };
    public static final ValueConverter<List<?>> COLLECTION_TO_FLAT_LIST = new ValueConverter<List<?>>(){

        @Override
        public List<?> convert(Object value) throws IllegalArgumentException {
            if (value instanceof Collection) {
                Collection source = (Collection)value;
                ArrayList<Object> target = new ArrayList<Object>(source.size());
                for (Object element : source) {
                    List<?> unnested = COLLECTION_OR_ARRAY_TO_FLAT_LIST.convert(element);
                    if (unnested == null) {
                        target.add(element);
                        continue;
                    }
                    target.addAll(unnested);
                }
                return target;
            }
            return null;
        }
    };
    public static final ValueConverter<List<?>> ARRAY_TO_FLAT_LIST = new ConcatenatedConverter(ARRAY_TO_LIST, COLLECTION_TO_FLAT_LIST);
    public static final ValueConverter<List<?>> COLLECTION_OR_ARRAY_TO_FLAT_LIST = new CompositeValueConverter().add(COLLECTION_TO_FLAT_LIST).add(ARRAY_TO_FLAT_LIST);
    public static final ValueConverter<List<?>> DEFAULT = new CompositeValueConverter().add(COLLECTION_TO_LIST).add(ARRAY_TO_LIST).add(OBJECT_TO_SINGLETON_LIST);
    public static final ValueConverter<List<?>> FLATTEN = new CompositeValueConverter().add(COLLECTION_OR_ARRAY_TO_FLAT_LIST).add(OBJECT_TO_SINGLETON_LIST);
}

