/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.convert;

import java.util.ArrayList;
import java.util.List;
import org.unix4j.convert.ValueConverter;
import org.unix4j.util.Range;

public class RangeConverters {
    public static final ValueConverter<Range> STRING = new ValueConverter<Range>(){

        @Override
        public Range convert(Object value) throws IllegalArgumentException {
            if (value != null) {
                String[] values = value.toString().split("\\s*,\\s*");
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (String s : values) {
                    int dashIndex = s.indexOf(45);
                    try {
                        if (dashIndex < 0) {
                            indices.add(Integer.parseInt(s));
                            continue;
                        }
                        if (dashIndex == 0) {
                            indices.add(Integer.parseInt(s));
                            continue;
                        }
                        if (dashIndex == s.length() - 1) {
                            indices.add(Integer.parseInt(s.substring(0, dashIndex)));
                            indices.add(-2147483647);
                            continue;
                        }
                        indices.add(Integer.parseInt(s.substring(0, dashIndex)));
                        indices.add(Integer.parseInt(s.substring(dashIndex)));
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                if (!indices.isEmpty()) {
                    return this.toRange(value, indices);
                }
            }
            return null;
        }

        private Range toRange(Object value, List<Integer> indices) {
            int lastIndex = 0;
            Range range = null;
            for (int index : indices) {
                if (index == 0) {
                    throw new IllegalArgumentException("invalid index 0 in range expression: " + value);
                }
                if (index > 0) {
                    if (lastIndex > 0) {
                        range = range == null ? Range.of(lastIndex) : range.andOf(lastIndex);
                    }
                    lastIndex = index;
                    continue;
                }
                int start = lastIndex == 0 ? 1 : lastIndex;
                range = range == null ? Range.between(start, -index) : range.andBetween(start, -index);
                lastIndex = -1;
            }
            if (lastIndex > 0) {
                return range == null ? Range.of(lastIndex) : range.andOf(lastIndex);
            }
            return range;
        }
    };
    public static final ValueConverter<Range> DEFAULT = STRING;
}

