/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.io;

import java.util.LinkedList;
import org.unix4j.io.AbstractInput;
import org.unix4j.line.Line;
import org.unix4j.line.SimpleLine;
import org.unix4j.util.LineUtil;

public class BufferedInput
extends AbstractInput {
    private final LinkedList<Line> buffer;

    public BufferedInput(LinkedList<Line> buffer) {
        this.buffer = buffer;
    }

    @Override
    public boolean hasMoreLines() {
        return !this.buffer.isEmpty();
    }

    @Override
    public Line readLine() {
        if (!this.buffer.isEmpty()) {
            Line line = this.buffer.remove(0);
            if (!this.buffer.isEmpty() && line.getLineEndingLength() == 0) {
                return new SimpleLine(line);
            }
            return line;
        }
        return null;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public String toMultiLineString() {
        return LineUtil.toMultiLineString(this.buffer);
    }

    @Override
    public void close() {
    }
}

