/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.io;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.unix4j.io.BufferedInput;
import org.unix4j.io.Output;
import org.unix4j.line.Line;
import org.unix4j.util.LineUtil;

public class BufferedOutput
implements Output {
    private final List<Line> buffer;

    public BufferedOutput() {
        this(new ArrayList<Line>());
    }

    public BufferedOutput(List<Line> buffer) {
        this.buffer = buffer;
    }

    @Override
    public boolean processLine(Line line) {
        this.buffer.add(line);
        return true;
    }

    @Override
    public void finish() {
    }

    public String toString() {
        return this.buffer.toString();
    }

    public String toMultiLineString() {
        return LineUtil.toMultiLineString(this.buffer);
    }

    public void writeTo(Output output) {
        boolean more = true;
        for (int i = 0; i < this.buffer.size() && more; ++i) {
            more = output.processLine(this.buffer.get(i));
        }
        output.finish();
    }

    public BufferedInput asInput() {
        return new BufferedInput(new LinkedList<Line>(this.buffer));
    }

    public List<Line> asList() {
        return new ArrayList<Line>(this.buffer);
    }

    public int size() {
        return this.buffer.size();
    }

    public BufferedOutput clear() {
        this.buffer.clear();
        return this;
    }
}

