/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.io;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.unix4j.io.BufferedInput;
import org.unix4j.io.Input;
import org.unix4j.io.IteratorInput;
import org.unix4j.line.Line;
import org.unix4j.util.StringUtil;

public class StringInput
implements Input {
    private final Input input;

    public StringInput(String ... lines) {
        this(new BufferedInput(StringInput.toList(lines)));
    }

    public StringInput(Iterable<? extends String> lines) {
        this(lines instanceof Collection ? new BufferedInput(StringInput.toList(lines)) : new IteratorInput(StringInput.toIterator(lines)));
    }

    public StringInput(Stream<? extends String> lines) {
        this(lines.iterator());
    }

    public StringInput(Iterator<? extends String> lines) {
        this(new IteratorInput(StringInput.toIterator(lines)));
    }

    private StringInput(Input input) {
        this.input = input;
    }

    @Override
    public boolean hasMoreLines() {
        return this.input.hasMoreLines();
    }

    @Override
    public Line readLine() {
        return this.input.readLine();
    }

    @Override
    public Iterator<Line> iterator() {
        return this.input.iterator();
    }

    @Override
    public void close() {
        this.input.close();
    }

    public String toString() {
        return this.input.toString();
    }

    public String toMultilineString() {
        if (this.input instanceof BufferedInput) {
            return ((BufferedInput)this.input).toMultiLineString();
        }
        return this.toString();
    }

    private static LinkedList<Line> toList(String[] lines) {
        LinkedList<Line> list = new LinkedList<Line>();
        for (int i = 0; i < lines.length; ++i) {
            list.addAll(StringUtil.splitLines(lines[i]));
        }
        return list;
    }

    private static LinkedList<Line> toList(Iterable<? extends String> lines) {
        LinkedList<Line> list = new LinkedList<Line>();
        for (String string : lines) {
            list.addAll(StringUtil.splitLines(string));
        }
        return list;
    }

    private static Iterator<Line> toIterator(Iterable<? extends String> lines) {
        return StringInput.toIterator(lines.iterator());
    }

    private static Iterator<Line> toIterator(final Iterator<? extends String> lines) {
        return new Iterator<Line>(){
            final LinkedList<Line> next = new LinkedList();

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Line next() {
                if (this.next.isEmpty() && lines.hasNext()) {
                    this.next.addAll(StringUtil.splitLines((String)lines.next()));
                }
                return this.next.isEmpty() ? null : this.next.removeFirst();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported");
            }
        };
    }
}

