/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.io;

import java.io.IOException;
import java.io.Writer;
import org.unix4j.io.Output;
import org.unix4j.line.Line;

public class WriterOutput
implements Output {
    private final Writer writer;
    private final boolean closeWriterOnFinish;
    private Line lastTerminatedLine;
    private Line lastLine;

    public WriterOutput(Writer writer) {
        this(writer, false);
    }

    protected WriterOutput(Writer writer, boolean closeWriterOnFinish) {
        this.writer = writer;
        this.closeWriterOnFinish = closeWriterOnFinish;
        this.init();
    }

    private void init() {
        this.lastTerminatedLine = Line.EMPTY_LINE;
        this.lastLine = null;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    @Override
    public boolean processLine(Line line) {
        try {
            if (this.lastLine != null) {
                this.writer.write(this.lastTerminatedLine.getLineEnding());
            }
            this.writer.write(line.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lastLine = line;
        if (line.getLineEndingLength() > 0) {
            this.lastTerminatedLine = line;
        }
        return true;
    }

    @Override
    public void finish() {
        try {
            if (this.lastLine != null && this.writeLastLineEnding()) {
                this.writer.write(this.lastLine.getLineEnding());
            }
            if (this.closeWriterOnFinish) {
                this.writer.close();
            } else {
                this.writer.flush();
            }
            this.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean writeLastLineEnding() {
        return true;
    }
}

