/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.line;

import org.unix4j.line.Line;

public class SimpleLine
implements Line {
    private final CharSequence content;
    private final CharSequence lineEnding;

    public SimpleLine(CharSequence content) {
        this(content, LINE_ENDING);
    }

    public SimpleLine(CharSequence content, char lineEnding) {
        this(content, String.valueOf(lineEnding));
    }

    public SimpleLine(CharSequence content, CharSequence lineEnding) {
        if (content == null) {
            throw new NullPointerException("content cannot be null");
        }
        int elen = lineEnding.length();
        if (elen > 2) {
            throw new IllegalArgumentException("lineEndingLength must be a string of length two or less, but was found to be " + elen + ": " + lineEnding);
        }
        this.content = content;
        this.lineEnding = lineEnding;
    }

    @Override
    public int length() {
        return this.content.length() + this.lineEnding.length();
    }

    @Override
    public char charAt(int index) {
        return index < this.content.length() ? this.content.charAt(index) : this.lineEnding.charAt(index - this.content.length());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int clen = this.content.length();
        int elen = this.lineEnding.length();
        if (start < clen && end <= clen) {
            return this.content.subSequence(start, end);
        }
        int estart = start - clen;
        int eend = end - clen;
        if (estart >= 0 && estart <= elen && eend >= 0 && eend <= elen) {
            return this.lineEnding.subSequence(estart, eend);
        }
        StringBuilder sb = new StringBuilder(clen + elen);
        return sb.append(this.content).append(this.lineEnding).subSequence(start, end);
    }

    @Override
    public String getContent() {
        return this.content.toString();
    }

    @Override
    public int getContentLength() {
        return this.content.length();
    }

    @Override
    public String getLineEnding() {
        return this.lineEnding.toString();
    }

    @Override
    public int getLineEndingLength() {
        return this.lineEnding.length();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.content.length() + this.lineEnding.length());
        return sb.append(this.content).append(this.lineEnding).toString();
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Line) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public static Line subLine(Line line, int start, int end, boolean preserveLineEnding) {
        if (start == 0 && (end == line.length() || preserveLineEnding && end == line.getContentLength())) {
            return line;
        }
        if (start < 0) {
            throw new IllegalArgumentException("start cannot be negative: " + start);
        }
        if (end < 0) {
            throw new IllegalArgumentException("end cannot be negative: " + end);
        }
        if (start > end) {
            throw new IllegalArgumentException("start cannot be after end: " + start + " > " + end);
        }
        if (preserveLineEnding) {
            if (end > line.getContentLength()) {
                throw new IllegalArgumentException("start cannot be after line content end: " + end + " > " + line.getContentLength());
            }
            return new SimpleLine(line.subSequence(start, end), line.getLineEnding());
        }
        int clen = line.getContentLength();
        if (end > line.length()) {
            throw new IllegalArgumentException("start cannot be after line end: " + end + " > " + line.length());
        }
        if (end <= clen) {
            return new SimpleLine(line.subSequence(start, end), "");
        }
        if (start < clen) {
            return new SimpleLine(line.subSequence(start, clen), line.subSequence(line.getContentLength(), end));
        }
        return new SimpleLine((CharSequence)"", line.subSequence(start, end));
    }
}

