/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.line;

import org.unix4j.line.Line;

public class SingleCharSequenceLine
implements Line {
    private final CharSequence charSequence;
    private final int offset;
    private final int contentLength;
    private final int lineEndingLength;
    private String content = null;

    public SingleCharSequenceLine(CharSequence charSequence, int lineEndingLength) {
        this(charSequence, 0, charSequence.length() - lineEndingLength, lineEndingLength);
    }

    public SingleCharSequenceLine(CharSequence charSequence, int offset, int contentLength, int lineEndingLength) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be non-negative, but was found to be " + offset);
        }
        if (contentLength < 0) {
            throw new IllegalArgumentException("contentLength must be non-negative, but was found to be " + contentLength);
        }
        if (lineEndingLength < 0 || lineEndingLength > 2) {
            throw new IllegalArgumentException("lineEndingLength must between zero and two, but was found to be " + lineEndingLength);
        }
        if (offset + contentLength + lineEndingLength > charSequence.length()) {
            throw new IndexOutOfBoundsException("line end is after charSequence end: " + (offset + contentLength + lineEndingLength) + " > " + charSequence.length());
        }
        this.charSequence = charSequence;
        this.offset = offset;
        this.contentLength = contentLength;
        this.lineEndingLength = lineEndingLength;
    }

    @Override
    public int length() {
        return this.contentLength + this.lineEndingLength;
    }

    @Override
    public char charAt(int index) {
        return this.charSequence.charAt(this.offset + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.charSequence.subSequence(this.offset + start, this.offset + end);
    }

    @Override
    public String getContent() {
        if (this.content == null) {
            this.content = this.charSequence.subSequence(this.offset, this.offset + this.contentLength).toString();
        }
        return this.content;
    }

    @Override
    public int getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getLineEnding() {
        return this.charSequence.subSequence(this.offset + this.contentLength, this.offset + this.contentLength + this.lineEndingLength).toString();
    }

    @Override
    public int getLineEndingLength() {
        return this.lineEndingLength;
    }

    @Override
    public String toString() {
        return this.charSequence.subSequence(this.offset, this.offset + this.contentLength + this.lineEndingLength).toString();
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Line) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }
}

