/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.processor;

import java.util.List;
import org.unix4j.command.ExitValueException;
import org.unix4j.io.Input;
import org.unix4j.line.Line;
import org.unix4j.processor.InputProcessor;
import org.unix4j.processor.LineProcessor;

public class MultipleInputLineProcessor
implements LineProcessor {
    private final List<? extends Input> inputs;
    private final InputProcessor processor;
    private final LineProcessor output;
    private final LineProcessor nonFinishingOutput;

    public MultipleInputLineProcessor(List<? extends Input> inputs, InputProcessor processor, final LineProcessor output) {
        this.inputs = inputs;
        this.processor = processor;
        this.output = output;
        this.nonFinishingOutput = new LineProcessor(){

            @Override
            public boolean processLine(Line line) {
                return output.processLine(line);
            }

            @Override
            public void finish() {
            }
        };
    }

    @Override
    public boolean processLine(Line line) {
        return false;
    }

    @Override
    public void finish() {
        this.beginMultiple(this.inputs, this.output);
        for (int i = 0; i < this.inputs.size(); ++i) {
            Input input = this.inputs.get(i);
            try {
                this.processor.begin(input, this.output);
                for (Line line : input) {
                    if (!this.processor.processLine(input, line, this.output)) break;
                }
                this.processor.finish(input, this.nonFinishingOutput);
                continue;
            }
            catch (ExitValueException e) {
                e.setInput(input);
                throw e;
            }
        }
        this.finishMultiple(this.inputs, this.output);
    }

    protected void beginMultiple(List<? extends Input> inputs, LineProcessor output) {
    }

    protected void finishMultiple(List<? extends Input> inputs, LineProcessor output) {
        output.finish();
        for (Input input : inputs) {
            input.close();
        }
    }
}

