/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.unix4j.util.ResourceUtil;

public class PropertyUtil {
    public static String getProperty(String defaultPropertiesFile, String propertyName, String fallbackValue) {
        Properties props = PropertyUtil.getProperties(defaultPropertiesFile);
        if (props == null) {
            throw new IllegalArgumentException("default properties file not found: " + defaultPropertiesFile);
        }
        return props.getProperty(propertyName, fallbackValue);
    }

    public static Properties getProperties(String defaultPropertiesFile) {
        try {
            Properties properties = new Properties();
            properties.load(ResourceUtil.getResource(PropertyUtil.class, defaultPropertiesFile));
            String userPropertiesFile = PropertyUtil.getUserPropertiesFileNameFor(defaultPropertiesFile);
            InputStream userPropertiesStream = null;
            try {
                userPropertiesStream = ResourceUtil.getResource(PropertyUtil.class, userPropertiesFile);
            }
            catch (IllegalArgumentException e) {
                System.err.println("WARN: user properties file not found : " + userPropertiesFile);
                System.err.println("WARN: using default properties file  : " + defaultPropertiesFile);
            }
            if (userPropertiesStream != null) {
                Properties userProperties = new Properties();
                userProperties.load(userPropertiesStream);
                properties.putAll((Map<?, ?>)userProperties);
            }
            return properties;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getUserPropertiesFileNameFor(String defaultPropertiesFile) {
        String defaultPostfix = "-default";
        String localPostfix = "-" + PropertyUtil.getUserName();
        String ending = ".properties";
        String postfix = "-default.properties";
        if (defaultPropertiesFile.endsWith("-default.properties")) {
            return defaultPropertiesFile.substring(0, defaultPropertiesFile.length() - "-default.properties".length()) + localPostfix + ".properties";
        }
        throw new IllegalArgumentException("name of default properties file must end with -default.properties: " + defaultPropertiesFile);
    }

    private static String getUserName() {
        String userName = System.getProperty("user.name", null);
        if (userName != null) {
            return userName;
        }
        throw new IllegalStateException("cannot evaulate user.name from system properties");
    }

    private PropertyUtil() {
    }
}

