/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util;

import java.util.ArrayList;
import java.util.List;
import org.unix4j.line.Line;
import org.unix4j.line.SingleCharSequenceLine;

public class StringUtil {
    public static String fixSizeString(int size, boolean alignLeft, char filler, long value) {
        return StringUtil.fixSizeString(size, alignLeft, filler, String.valueOf(value));
    }

    public static String fixSizeString(int size, boolean alignLeft, String s) {
        return StringUtil.fixSizeString(size, alignLeft, ' ', s);
    }

    public static String fixSizeString(int size, boolean alignLeft, char filler, String s) {
        if (s.length() < size) {
            StringBuilder sb = new StringBuilder(size);
            if (alignLeft) {
                sb.append(s);
            }
            for (int i = 0; i < size - s.length(); ++i) {
                sb.append(filler);
            }
            if (!alignLeft) {
                sb.append(s);
            }
            return sb.toString();
        }
        return alignLeft ? s.substring(0, size) : s.substring(s.length() - size, s.length());
    }

    public static List<Line> splitLines(String s) {
        ArrayList<Line> lines = new ArrayList<Line>();
        int start = 0;
        int index = 0;
        while (index < s.length()) {
            char ch = s.charAt(index);
            if (ch == '\n' || ch == '\r') {
                char ch2;
                int lineEndingStart = index++;
                if (index < s.length() && (ch2 = s.charAt(index)) != ch && (ch2 == '\n' || ch2 == '\r')) {
                    ++index;
                }
                SingleCharSequenceLine line = new SingleCharSequenceLine(s, start, lineEndingStart - start, index - lineEndingStart);
                lines.add(line);
                start = index;
                continue;
            }
            ++index;
        }
        if (start < s.length()) {
            SingleCharSequenceLine line = new SingleCharSequenceLine(s, start, s.length() - start, 0);
            lines.add(line);
        }
        return lines;
    }

    public static int findStartTrimWhitespace(CharSequence s) {
        return StringUtil.findStartTrimWhitespace(s, 0);
    }

    public static int findStartTrimWhitespace(CharSequence s, int start) {
        int len = s.length();
        for (int i = start; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return len;
    }

    public static int findEndTrimWhitespace(CharSequence s) {
        for (int i = s.length(); i > 0; --i) {
            if (Character.isWhitespace(s.charAt(i - 1))) continue;
            return i;
        }
        return 0;
    }

    public static int findStartTrimNewlineChars(CharSequence s) {
        return StringUtil.findStartTrimNewlineChars(s, 0);
    }

    public static int findStartTrimNewlineChars(CharSequence s, int start) {
        int len = s.length();
        int i = start;
        while (i < len) {
            char ch = s.charAt(i);
            ++i;
            if (ch == '\n') continue;
            if (ch != '\r' || i >= len || s.charAt(i) != '\n') {
                return i - 1;
            }
            ++i;
        }
        return len;
    }

    public static int findEndTrimNewlineChars(CharSequence s) {
        int i = s.length();
        while (i > 0) {
            if (s.charAt(i - 1) != '\n') {
                return i;
            }
            if (--i <= 0 || s.charAt(i - 1) != '\r') continue;
            --i;
        }
        return 0;
    }

    public static int findWhitespace(CharSequence s) {
        return StringUtil.findWhitespace(s, 0);
    }

    public static int findWhitespace(CharSequence s, int start) {
        int len = s.length();
        for (int i = start; i < len; ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return len;
    }

    public static boolean containsIgnoreCase(String source, String target) {
        return 0 <= StringUtil.indexOfIgnoreCase(source, target);
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        return 0 == StringUtil.indexOfIgnoreCase(s, prefix, 0);
    }

    public static int indexOfIgnoreCase(String source, String target) {
        return StringUtil.indexOfIgnoreCase(source, target, Integer.MAX_VALUE);
    }

    private static int indexOfIgnoreCase(String source, String target, int maxIndex) {
        if (maxIndex < 0) {
            throw new IllegalArgumentException("maxIndex cannot be negative: " + maxIndex);
        }
        int sourceCount = source.length();
        int targetCount = target.length();
        char first = target.charAt(0);
        int max = Math.min(maxIndex, sourceCount - targetCount);
        for (int i = 0; i <= max; ++i) {
            if (!StringUtil.equalsIgnoreCase(source.charAt(i), first)) {
                while (++i <= max && !StringUtil.equalsIgnoreCase(source.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.equalsIgnoreCase(source.charAt(j), target.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static boolean equalsIgnoreCase(char ch1, char ch2) {
        if (ch1 == ch2) {
            return true;
        }
        if ((ch1 = Character.toUpperCase(ch1)) == (ch2 = Character.toUpperCase(ch2))) {
            return true;
        }
        return Character.toLowerCase(ch1) == Character.toLowerCase(ch2);
    }

    private StringUtil() {
    }
}

