/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util.sort;

import java.util.Comparator;
import java.util.Objects;

public class DictionaryStringComparator
implements Comparator<String> {
    private final Comparator<? super String> comparator;

    public DictionaryStringComparator(Comparator<? super String> comparator) {
        this.comparator = Objects.requireNonNull(comparator);
    }

    @Override
    public int compare(String s1, String s2) {
        return this.comparator.compare(DictionaryStringComparator.dictionaryString(s1), DictionaryStringComparator.dictionaryString(s2));
    }

    private static String dictionaryString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (DictionaryStringComparator.isBlankOrAlphaNumeric(s.charAt(i))) continue;
            return DictionaryStringComparator.convertToDictionaryString(s);
        }
        return s;
    }

    private static String convertToDictionaryString(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (!DictionaryStringComparator.isBlankOrAlphaNumeric(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    private static boolean isBlankOrAlphaNumeric(char ch) {
        return Character.isWhitespace(ch) || Character.isDigit(ch) || Character.isLetter(ch);
    }
}

