/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util.sort;

import java.text.Collator;
import java.util.Comparator;
import java.util.Objects;
import org.unix4j.line.Line;
import org.unix4j.util.sort.DictionaryStringComparator;
import org.unix4j.util.sort.TrimBlanksStringComparator;

public class LineComparator
implements Comparator<Line> {
    private final Comparator<? super String> comparator;

    public LineComparator(Comparator<? super String> comparator) {
        this.comparator = Objects.requireNonNull(comparator);
    }

    public LineComparator(boolean ignoreCase, boolean ignoreLeadingBlanks, boolean onlyDictionaryChars) {
        this(LineComparator.getCollator(ignoreCase, ignoreLeadingBlanks, onlyDictionaryChars));
    }

    @Override
    public int compare(Line line1, Line line2) {
        return this.comparator.compare(line1.getContent(), line2.getContent());
    }

    private static Comparator<? super String> getCollator(boolean ignoreCase, boolean ignoreLeadingBlanks, boolean onlyDictionaryChars) {
        Collator collator = Collator.getInstance();
        collator.setStrength(ignoreCase ? 1 : Math.max(2, collator.getStrength()));
        Comparator<Object> comparator = ignoreLeadingBlanks ? new TrimBlanksStringComparator(TrimBlanksStringComparator.Mode.Leading, collator) : collator;
        if (onlyDictionaryChars) {
            return new DictionaryStringComparator(comparator);
        }
        return comparator;
    }
}

