/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util.sort;

import java.text.DateFormatSymbols;
import java.util.Comparator;
import java.util.Locale;
import org.unix4j.util.StringUtil;

public class MonthStringComparator
implements Comparator<CharSequence> {
    private static final MonthStringComparator DEFAULT_INSTANCE = new MonthStringComparator();
    private final String[] months;
    private final String[] shortMonths;

    public static MonthStringComparator getInstance() {
        return DEFAULT_INSTANCE;
    }

    public static MonthStringComparator getInstance(Locale locale) {
        return new MonthStringComparator(locale);
    }

    private MonthStringComparator() {
        this(DateFormatSymbols.getInstance());
    }

    private MonthStringComparator(Locale locale) {
        this(DateFormatSymbols.getInstance(locale));
    }

    public MonthStringComparator(DateFormatSymbols symbols) {
        this.months = symbols.getMonths();
        this.shortMonths = symbols.getShortMonths();
    }

    @Override
    public int compare(CharSequence s1, CharSequence s2) {
        int start1 = StringUtil.findStartTrimWhitespace(s1);
        int end1 = StringUtil.findEndTrimWhitespace(s1);
        int start2 = StringUtil.findStartTrimWhitespace(s2);
        int end2 = StringUtil.findEndTrimWhitespace(s2);
        int month1 = this.month(s1, start1, end1);
        int month2 = this.month(s2, start2, end2);
        return Integer.compare(month1, month2);
    }

    private final int month(CharSequence s, int start, int end) {
        int m = MonthStringComparator.month(this.months, s, start, end);
        return m >= 0 ? m : MonthStringComparator.month(this.shortMonths, s, start, end);
    }

    private static int month(String[] months, CharSequence s, int start, int end) {
        for (int i = 0; i < months.length; ++i) {
            String month = months[i];
            if (!MonthStringComparator.equalsIgnoreCase(month, s, start, end)) continue;
            return i;
        }
        return -1;
    }

    private static final boolean equalsIgnoreCase(String s1, CharSequence s2, int start, int end) {
        if (end - start != s1.length()) {
            return false;
        }
        for (int i = start; i < end; ++i) {
            if (MonthStringComparator.equalsIgnoreCase(s1.charAt(i - start), s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final boolean equalsIgnoreCase(char ch1, char ch2) {
        return Character.toUpperCase(ch1) == Character.toUpperCase(ch2);
    }
}

