/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util.sort;

import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import org.unix4j.util.StringUtil;
import org.unix4j.util.sort.DecimalNumberStringComparator;

public class UnitsNumberStringComparator
implements Comparator<CharSequence> {
    private static final String SI_UNITS = "KMGTPEZY";
    private static final UnitsNumberStringComparator DEFAULT_INSTANCE = new UnitsNumberStringComparator();
    private final DecimalNumberStringComparator numberComparator;

    public static UnitsNumberStringComparator getInstance() {
        return DEFAULT_INSTANCE;
    }

    public static UnitsNumberStringComparator getInstance(Locale locale) {
        return new UnitsNumberStringComparator(locale);
    }

    private UnitsNumberStringComparator() {
        this(DecimalNumberStringComparator.getInstance());
    }

    private UnitsNumberStringComparator(Locale locale) {
        this(DecimalNumberStringComparator.getInstance(locale));
    }

    public UnitsNumberStringComparator(DecimalNumberStringComparator numberComparator) {
        this.numberComparator = Objects.requireNonNull(numberComparator);
    }

    @Override
    public int compare(CharSequence s1, CharSequence s2) {
        int start1 = StringUtil.findStartTrimWhitespace(s1);
        int end1 = StringUtil.findEndTrimWhitespace(s1);
        int start2 = StringUtil.findStartTrimWhitespace(s2);
        int end2 = StringUtil.findEndTrimWhitespace(s2);
        boolean isNeg1 = start1 < end1 && s1.charAt(start1) == '-';
        boolean isNeg2 = start2 < end2 && s2.charAt(start2) == '-';
        int si1 = UnitsNumberStringComparator.siUnit(s1, start1, end1);
        int si2 = UnitsNumberStringComparator.siUnit(s2, start2, end2);
        int e1 = si1 < 0 ? end1 : end1 - 1;
        int e2 = si2 < 0 ? end2 : end2 - 1;
        int cmp = this.numberComparator.compare(s1, start1, e1, s2, start2, e2);
        if (isNeg1 != isNeg2) {
            return cmp;
        }
        if (si1 < si2) {
            return isNeg1 ? 1 : -1;
        }
        if (si1 > si2) {
            return isNeg1 ? -1 : 1;
        }
        return cmp;
    }

    private static final int siUnit(CharSequence s, int start, int end) {
        if (start < end) {
            char ch = s.charAt(end - 1);
            int si = SI_UNITS.indexOf(ch);
            if (si >= 0) {
                return si;
            }
            if (ch == 'k') {
                return 0;
            }
        }
        return -1;
    }
}

