/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util.sort;

import java.util.Comparator;
import org.unix4j.util.StringUtil;

public class VersionStringComparator
implements Comparator<CharSequence> {
    public static final VersionStringComparator INSTANCE = new VersionStringComparator();

    private VersionStringComparator() {
    }

    @Override
    public int compare(CharSequence s1, CharSequence s2) {
        int start1 = StringUtil.findStartTrimWhitespace(s1);
        int end1 = StringUtil.findEndTrimWhitespace(s1);
        int start2 = StringUtil.findStartTrimWhitespace(s2);
        int end2 = StringUtil.findEndTrimWhitespace(s2);
        int grpStart1 = start1;
        int grpStart2 = start2;
        int grpEnd1 = VersionStringComparator.findGroupEnd(s1, start1, end1);
        int grpEnd2 = VersionStringComparator.findGroupEnd(s2, start2, end2);
        while (grpStart1 < grpEnd1 && grpStart2 < grpEnd2) {
            char ch1 = s1.charAt(grpStart1);
            char ch2 = s2.charAt(grpStart2);
            int cmp = Character.isDigit(ch1) && Character.isDigit(ch2) ? VersionStringComparator.compareGroupNumerically(s1, grpStart1, grpEnd1, s2, grpStart2, grpEnd2) : VersionStringComparator.compareGroupLiterally(s1, grpStart1, grpEnd1, s2, grpStart2, grpEnd2);
            if (cmp != 0) {
                return cmp;
            }
            grpStart1 = grpEnd1;
            grpStart2 = grpEnd2;
            grpEnd1 = VersionStringComparator.findGroupEnd(s1, grpStart1, end1);
            grpEnd2 = VersionStringComparator.findGroupEnd(s2, grpStart2, end2);
        }
        return grpStart1 < grpEnd1 ? 1 : (grpStart2 < grpEnd2 ? -1 : 0);
    }

    private static int compareGroupNumerically(CharSequence s1, int start1, int end1, CharSequence s2, int start2, int end2) {
        int len1 = end1 - start1;
        int len2 = end2 - start2;
        int maxlen = Math.max(len1, len2);
        int pad1 = maxlen - len1;
        int pad2 = maxlen - len2;
        int cmp = 0;
        for (int i = 0; i < maxlen; ++i) {
            int ch2;
            int ch1 = i < pad1 ? 48 : (int)s1.charAt(start1 + i - pad1);
            int n = ch2 = i < pad2 ? 48 : (int)s2.charAt(start2 + i - pad2);
            if (cmp != 0) continue;
            cmp = ch1 < ch2 ? -1 : (ch1 > ch2 ? 1 : 0);
        }
        if (cmp == 0) {
            return pad1 < pad2 ? -1 : (pad1 > pad2 ? 1 : 0);
        }
        return cmp;
    }

    private static int compareGroupLiterally(CharSequence s1, int start1, int end1, CharSequence s2, int start2, int end2) {
        int len1 = end1 - start1;
        int len2 = end2 - start2;
        int minlen = Math.min(len1, len2);
        for (int i = 0; i < minlen; ++i) {
            char ch2;
            char ch1 = s1.charAt(start1 + i);
            if (ch1 < (ch2 = s2.charAt(start2 + i))) {
                return -1;
            }
            if (ch1 <= ch2) continue;
            return 1;
        }
        return len1 > minlen ? 1 : (len2 > minlen ? -1 : 0);
    }

    private static int findGroupEnd(CharSequence s, int start, int end) {
        Boolean isNumeric = null;
        for (int i = start; i < end; ++i) {
            boolean isDigit = Character.isDigit(s.charAt(i));
            if (isNumeric == null) {
                isNumeric = isDigit;
                continue;
            }
            if (isNumeric == isDigit) continue;
            return i;
        }
        return end;
    }
}

