/*
 * Decompiled with CFR 0.152.
 */
package uqbar.arena.persistence.mapping;

import java.util.Collection;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.uqbar.commons.model.Entity;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import uqbar.arena.persistence.Session;
import uqbar.arena.persistence.mapping.QueryBuilder;
import uqbar.arena.persistence.mapping.RelationMapping;
import uqbar.arena.persistence.reflection.TypeWrapper;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u0017\tI2i\u001c7mK\u000e$\u0018n\u001c8SK2\fG/[8o\u001b\u0006\u0004\b/\u001b8h\u0015\t\u0019A!A\u0004nCB\u0004\u0018N\\4\u000b\u0005\u00151\u0011a\u00039feNL7\u000f^3oG\u0016T!a\u0002\u0005\u0002\u000b\u0005\u0014XM\\1\u000b\u0003%\tQ!^9cCJ\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\u0010%\u0016d\u0017\r^5p]6\u000b\u0007\u000f]5oO\"A\u0011\u0003\u0001B\u0001B\u0003%!#\u0001\u0003oC6,\u0007CA\n\u001a\u001d\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011!d\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a)\u0002\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0017]\u0014\u0018\r\u001d9fIRK\b/\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0003C\u0011\t!B]3gY\u0016\u001cG/[8o\u0013\t\u0019\u0003EA\u0006UsB,wK]1qa\u0016\u0014\b\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\bF\u0002(Q%\u0002\"!\u0004\u0001\t\u000bE!\u0003\u0019\u0001\n\t\u000bu!\u0003\u0019\u0001\u0010\t\u000b-\u0002A\u0011\u0001\u0017\u0002\u000bE,XM]=\u0015\u00075\u0002T\u0007\u0005\u0002\u0015]%\u0011q&\u0006\u0002\u0005+:LG\u000fC\u00032U\u0001\u0007!'\u0001\u0007rk\u0016\u0014\u0018PQ;jY\u0012,'\u000f\u0005\u0002\u000eg%\u0011AG\u0001\u0002\r#V,'/\u001f\"vS2$WM\u001d\u0005\u0006m)\u0002\raN\u0001\u0007i\u0006\u0014x-\u001a;\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001\u00027b]\u001eT\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u0002?s\t1qJ\u00196fGRDQ\u0001\u0011\u0001\u0005\u0002\u0005\u000bq\u0001]3sg&\u001cH\u000f\u0006\u0003.\u0005\"#\u0006\"B\"@\u0001\u0004!\u0015aB:fgNLwN\u001c\t\u0003\u000b\u001ak\u0011\u0001B\u0005\u0003\u000f\u0012\u0011qaU3tg&|g\u000eC\u0003J\u007f\u0001\u0007!*\u0001\u0003o_\u0012,\u0007CA&S\u001b\u0005a%BA'O\u0003\u001d9'/\u00199iI\nT!a\u0014)\u0002\u000b9,w\u000e\u000e6\u000b\u0003E\u000b1a\u001c:h\u0013\t\u0019FJ\u0001\u0003O_\u0012,\u0007\"\u0002\u001c@\u0001\u00049\u0004\"\u0002,\u0001\t\u00039\u0016a\u00025jIJ\fG/\u001a\u000b\u0005[aK&\fC\u0003D+\u0002\u0007A\tC\u0003J+\u0002\u0007!\nC\u00037+\u0002\u0007q\u0007")
public class CollectionRelationMapping
extends RelationMapping {
    private final String name;
    private final TypeWrapper wrappedType;

    @Override
    public void query(QueryBuilder queryBuilder, Object target) {
        Collection value = (Collection)this.invokeGetter(target, this.name);
        if (value == null || value.isEmpty()) {
            return;
        }
        throw new Exception("Arena persistence no permite hacer query by example con relaciones entre objetos.");
    }

    @Override
    public void persist(Session session, Node node, Object target) {
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)this.name);
        GraphDatabaseService graphDB = session.graphDB();
        Iterable rels = node.getRelationships((RelationshipType)relType, Direction.OUTGOING);
        JavaConversions$.MODULE$.iterableAsScalaIterable(rels).foreach((Function1)new Serializable(this){

            public final void apply(Relationship r) {
                r.delete();
            }
        });
        Collection value = (Collection)this.invokeGetter(target, this.name);
        if (value == null || value.isEmpty()) {
            return;
        }
        JavaConversions$.MODULE$.collectionAsScalaIterable(value).foreach((Function1)new Serializable(this, session, node, relType, graphDB){
            private final Session session$1;
            private final Node node$1;
            private final DynamicRelationshipType relType$1;
            private final GraphDatabaseService graphDB$1;

            public final Relationship apply(Entity e) {
                if (e.isNew()) {
                    this.session$1.save(e);
                }
                Node otherNode = this.graphDB$1.getNodeById(e.getId().longValue());
                return this.node$1.createRelationshipTo(otherNode, (RelationshipType)this.relType$1);
            }
            {
                this.session$1 = session$1;
                this.node$1 = node$1;
                this.relType$1 = relType$1;
                this.graphDB$1 = graphDB$1;
            }
        });
    }

    @Override
    public void hidrate(Session session, Node node, Object target) {
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)this.name);
        GraphDatabaseService graphDB = session.graphDB();
        Iterable rels = node.getRelationships((RelationshipType)relType, Direction.OUTGOING);
        ObjectRef value = ObjectRef.create((Object)((Collection)this.invokeGetter(target, this.name)));
        if ((Collection)value.elem == null || !((Collection)value.elem).isEmpty()) {
            value.elem = (Collection)this.wrappedType.newInstance();
            this.invokeSetter(target, this.name, (Collection)value.elem);
        }
        JavaConversions$.MODULE$.iterableAsScalaIterable(rels).foreach((Function1)new Serializable(this, session, value){
            private final Session session$2;
            private final ObjectRef value$1;

            public final boolean apply(Relationship r) {
                Node otherNode = r.getEndNode();
                Entity entity = (Entity)this.session$2.get(otherNode.getProperty("clazzName").toString(), Predef$.MODULE$.long2Long(otherNode.getId()).intValue());
                return ((Collection)this.value$1.elem).add(entity);
            }
            {
                this.session$2 = session$2;
                this.value$1 = value$1;
            }
        });
    }

    public CollectionRelationMapping(String name, TypeWrapper wrappedType) {
        this.name = name;
        this.wrappedType = wrappedType;
        super(name, wrappedType);
    }
}

