/*
 * Decompiled with CFR 0.152.
 */
package uqbar.arena.persistence.mapping;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.uqbar.commons.utils.ReflectionUtils;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import uqbar.arena.persistence.ConfigurationException;
import uqbar.arena.persistence.Session;
import uqbar.arena.persistence.mapping.FieldMapping$;
import uqbar.arena.persistence.mapping.Mapping;
import uqbar.arena.persistence.mapping.QueryBuilder;
import uqbar.arena.persistence.reflection.TypeWrapper;

@ScalaSignature(bytes="\u0006\u0001\u0005eq!B\u0001\u0003\u0011\u0003Y\u0011\u0001\u0004$jK2$W*\u00199qS:<'BA\u0002\u0005\u0003\u001di\u0017\r\u001d9j]\u001eT!!\u0002\u0004\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003\u000f!\tQ!\u0019:f]\u0006T\u0011!C\u0001\u0006kF\u0014\u0017M]\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u000511\u0015.\u001a7e\u001b\u0006\u0004\b/\u001b8h'\ti\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/5!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-AQAG\u0007\u0005\u0002m\taa\u0019:fCR,G#\u0002\u000f\u0002\b\u0005%\u0001C\u0001\u0007\u001e\r\u0011q!\u0001\u0001\u0010\u0014\u0007u\u0001r\u0004\u0005\u0002\rA%\u0011\u0011E\u0001\u0002\b\u001b\u0006\u0004\b/\u001b8h\u0011!\u0019SD!A!\u0002\u0013!\u0013\u0001\u00028b[\u0016\u0004\"!\n\u0015\u000f\u0005E1\u0013BA\u0014\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011F\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d\u0012\u0002\u0002\u0003\u0017\u001e\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0017]\u0014\u0018\r\u001d9fIRK\b/\u001a\t\u0003]Ej\u0011a\f\u0006\u0003a\u0011\t!B]3gY\u0016\u001cG/[8o\u0013\t\u0011tFA\u0006UsB,wK]1qa\u0016\u0014\b\"B\f\u001e\t\u0003!Dc\u0001\u000f6m!)1e\ra\u0001I!)Af\ra\u0001[!)\u0001(\bC\u0001s\u0005\t2\r[3dW:\u000bG/\u001b<f\u001fJ,e.^7\u0015\u0003i\u0002\"!E\u001e\n\u0005q\u0012\"\u0001B+oSRDQAP\u000f\u0005\u0002}\nq\u0001]3sg&\u001cH\u000f\u0006\u0003;\u0001\u001a\u0013\u0006\"B!>\u0001\u0004\u0011\u0015aB:fgNLwN\u001c\t\u0003\u0007\u0012k\u0011\u0001B\u0005\u0003\u000b\u0012\u0011qaU3tg&|g\u000eC\u0003H{\u0001\u0007\u0001*\u0001\u0003o_\u0012,\u0007CA%Q\u001b\u0005Q%BA&M\u0003\u001d9'/\u00199iI\nT!!\u0014(\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\u000b1a\u001c:h\u0013\t\t&J\u0001\u0003O_\u0012,\u0007\"B*>\u0001\u0004!\u0016A\u0002;be\u001e,G\u000f\u0005\u0002V56\taK\u0003\u0002X1\u0006!A.\u00198h\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017,\u0003\r=\u0013'.Z2u\u0011\u0015iV\u0004\"\u0005_\u0003!9W\r\u001e,bYV,GC\u0001+`\u0011\u0015\u0019F\f1\u0001U\u0011\u0015\tW\u0004\"\u0005c\u0003Q\u0019wN\u001c<feR4\u0016\r\\;f\u0003\u001a$XM]$fiR\u0011Ak\u0019\u0005\u0006I\u0002\u0004\r\u0001V\u0001\u000e_JLw-\u001b8bYZ\u000bG.^3\t\u000b\u0019lB\u0011A4\u0002+\r|gN^3siZ\u000bG.^3CK\u001a|'/Z*fiR\u0011A\u000b\u001b\u0005\u0006I\u0016\u0004\r\u0001\u0016\u0005\u0006Uv!\ta[\u0001\bQ&$'/\u0019;f)\u0011QD.\u001c8\t\u000b\u0005K\u0007\u0019\u0001\"\t\u000b\u001dK\u0007\u0019\u0001%\t\u000bMK\u0007\u0019\u0001+\t\u000bAlB\u0011A9\u0002\u000bE,XM]=\u0015\u0007i\u0012x\u000fC\u0003t_\u0002\u0007A/\u0001\u0007rk\u0016\u0014\u0018PQ;jY\u0012,'\u000f\u0005\u0002\rk&\u0011aO\u0001\u0002\r#V,'/\u001f\"vS2$WM\u001d\u0005\u0006'>\u0004\r\u0001\u0016\u0005\u0006sv!\tA_\u0001\u0004Y><G#A>\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0A\u0003m_\u001e$$NC\u0002\u0002\u00029\u000ba!\u00199bG\",\u0017bAA\u0003{\n1Aj\\4hKJDQaI\rA\u0002\u0011Bq!a\u0003\u001a\u0001\u0004\ti!A\u0005gS\u0016dG\rV=qKB!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014Y\u000bqA]3gY\u0016\u001cG/\u0003\u0003\u0002\u0018\u0005E!\u0001\u0002+za\u0016\u0004")
public class FieldMapping
implements Mapping {
    private final String name;
    private final TypeWrapper wrappedType;

    public static FieldMapping create(String string, Type type) {
        return FieldMapping$.MODULE$.create(string, type);
    }

    public void checkNativeOrEnum() {
        if (this.wrappedType.isNative() || this.wrappedType.isEnum() || this.wrappedType.isBuiltinType()) {
            return;
        }
        throw new ConfigurationException(new StringBuilder().append((Object)"La annotation PersistentField es solo aplicable a tipos nativos, Enum, String, java.util.Date o java.math.BigDecimal:").append((Object)this.wrappedType.name()).toString());
    }

    @Override
    public void persist(Session session, Node node, Object target) {
        Object v = this.getValue(target);
        if (v == null) {
            node.removeProperty(this.name);
            session.graphDB().index().forNodes("Attr").remove((PropertyContainer)node, this.name);
        } else {
            session.graphDB().index().forNodes(new StringBuilder().append((Object)"Attr-").append((Object)target.getClass().toString()).toString()).add((PropertyContainer)node, this.name, v);
            node.setProperty(this.name, v);
        }
    }

    public Object getValue(Object target) {
        try {
            return this.convertValueAfterGet(ReflectionUtils.invokeGetter((Object)target, (String)this.name));
        }
        catch (RuntimeException runtimeException) {
            throw new Exception(new StringBuilder().append((Object)"Debe revisar el getter y setter de la propiedad ").append((Object)this.name).append((Object)" para la entidad ").append(target.getClass()).toString());
        }
    }

    public Object convertValueAfterGet(Object originalValue) {
        if (this.wrappedType.isEnum()) {
            return originalValue == null ? null : originalValue.toString();
        }
        if (this.wrappedType.isDate()) {
            return originalValue == null ? null : BoxesRunTime.boxToLong((long)((Date)originalValue).getTime());
        }
        if (this.wrappedType.isBigDecimal()) {
            return originalValue == null ? null : originalValue.toString();
        }
        if (this.wrappedType.isInt()) {
            return originalValue == null || BoxesRunTime.equals((Object)originalValue, (Object)BoxesRunTime.boxToInteger((int)0)) ? null : originalValue.toString();
        }
        return originalValue;
    }

    public Object convertValueBeforeSet(Object originalValue) {
        if (originalValue == null) {
            return null;
        }
        if (this.wrappedType.isEnum()) {
            return this.wrappedType.enumValue(originalValue);
        }
        if (this.wrappedType.isDate()) {
            return new Date(Predef$.MODULE$.Long2long((Long)originalValue));
        }
        if (this.wrappedType.isBigDecimal()) {
            return new BigDecimal((String)originalValue);
        }
        if (this.wrappedType.isInt()) {
            return new Integer(originalValue.toString());
        }
        return originalValue;
    }

    @Override
    public void hidrate(Session session, Node node, Object target) {
        try {
            ReflectionUtils.invokeSetter((Object)target, (String)this.name, (Object)this.convertValueBeforeSet(node.getProperty(this.name, null)));
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new Exception(new StringBuilder().append((Object)"Debe revisar el getter y setter de la propiedad ").append((Object)this.name).append((Object)" para la entidad ").append(target.getClass()).toString());
        }
    }

    @Override
    public void query(QueryBuilder queryBuilder, Object target) {
        String stringValue;
        Object v = this.getValue(target);
        if (v != null && !(stringValue = v.toString()).isEmpty()) {
            queryBuilder.add(this.name, stringValue);
        }
    }

    public Logger log() {
        return Logger.getLogger(this.getClass());
    }

    public FieldMapping(String name, TypeWrapper wrappedType) {
        this.name = name;
        this.wrappedType = wrappedType;
        this.checkNativeOrEnum();
    }
}

