/*
 * Decompiled with CFR 0.152.
 */
package uqbar.arena.persistence.mapping;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.uqbar.commons.model.Entity;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import uqbar.arena.persistence.Session;
import uqbar.arena.persistence.mapping.QueryBuilder;
import uqbar.arena.persistence.mapping.RelationMapping;
import uqbar.arena.persistence.reflection.TypeWrapper;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u0017\t)2+[7qY\u0016\u0014V\r\\1uS>tW*\u00199qS:<'BA\u0002\u0005\u0003\u001di\u0017\r\u001d9j]\u001eT!!\u0002\u0004\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003\u000f!\tQ!\u0019:f]\u0006T\u0011!C\u0001\u0006kF\u0014\u0017M]\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\ty!+\u001a7bi&|g.T1qa&tw\r\u0003\u0005\u0012\u0001\t\u0005\t\u0015!\u0003\u0013\u0003\u0011q\u0017-\\3\u0011\u0005MIbB\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001b7\t11\u000b\u001e:j]\u001eT!\u0001G\u000b\t\u0011u\u0001!\u0011!Q\u0001\ny\t1b\u001e:baB,G\rV=qKB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005B\u0001\u000be\u00164G.Z2uS>t\u0017BA\u0012!\u0005-!\u0016\u0010]3Xe\u0006\u0004\b/\u001a:\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\r9\u0003&\u000b\t\u0003\u001b\u0001AQ!\u0005\u0013A\u0002IAQ!\b\u0013A\u0002yAQa\u000b\u0001\u0005\u00021\nQ!];fef$2!\f\u00196!\t!b&\u0003\u00020+\t!QK\\5u\u0011\u0015\t$\u00061\u00013\u00031\tX/\u001a:z\u0005VLG\u000eZ3s!\ti1'\u0003\u00025\u0005\ta\u0011+^3ss\n+\u0018\u000e\u001c3fe\")aG\u000ba\u0001o\u00051A/\u0019:hKR\u0004\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\t1\fgn\u001a\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014H\u0001\u0004PE*,7\r\u001e\u0005\u0006\u0001\u0002!\t!Q\u0001\ba\u0016\u00148/[:u)\u0011i#\t\u0013+\t\u000b\r{\u0004\u0019\u0001#\u0002\u000fM,7o]5p]B\u0011QIR\u0007\u0002\t%\u0011q\t\u0002\u0002\b'\u0016\u001c8/[8o\u0011\u0015Iu\b1\u0001K\u0003\u0011qw\u000eZ3\u0011\u0005-\u0013V\"\u0001'\u000b\u00055s\u0015aB4sCBDGM\u0019\u0006\u0003\u001fB\u000bQA\\3pi)T\u0011!U\u0001\u0004_J<\u0017BA*M\u0005\u0011qu\u000eZ3\t\u000bYz\u0004\u0019A\u001c\t\u000bY\u0003A\u0011A,\u0002\u000f!LGM]1uKR!Q\u0006W-[\u0011\u0015\u0019U\u000b1\u0001E\u0011\u0015IU\u000b1\u0001K\u0011\u00151T\u000b1\u00018\u0001")
public class SimpleRelationMapping
extends RelationMapping {
    private final String name;

    @Override
    public void query(QueryBuilder queryBuilder, Object target) {
        Entity value = (Entity)this.invokeGetter(target, this.name);
        if (value == null) {
            return;
        }
        throw new Exception("Arena persistence no permite hacer query by example con relaciones entre objetos.");
    }

    @Override
    public void persist(Session session, Node node, Object target) {
        Object value = this.invokeGetter(target, this.name);
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)this.name);
        GraphDatabaseService graphDB = session.graphDB();
        Relationship r = node.getSingleRelationship((RelationshipType)relType, Direction.OUTGOING);
        if (r != null) {
            r.delete();
        }
        if (value == null) {
            return;
        }
        Entity entity = (Entity)value;
        if (entity.isNew()) {
            session.save(entity);
        }
        Node otherNode = graphDB.getNodeById(entity.getId().longValue());
        node.createRelationshipTo(otherNode, (RelationshipType)relType);
    }

    @Override
    public void hidrate(Session session, Node node, Object target) {
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)this.name);
        GraphDatabaseService graphDB = session.graphDB();
        Relationship r = node.getSingleRelationship((RelationshipType)relType, Direction.OUTGOING);
        if (r == null) {
            this.invokeSetter(target, this.name, null);
            return;
        }
        Node otherNode = r.getEndNode();
        Object entity = session.get(otherNode.getProperty("clazzName").toString(), Predef$.MODULE$.long2Long(otherNode.getId()).intValue());
        try {
            this.invokeSetter(target, this.name, entity);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new Exception(new StringBuilder().append((Object)"Debe revisar el getter y setter de la propiedad ").append((Object)this.name).append((Object)" para la entidad ").append(target.getClass()).toString());
        }
    }

    public SimpleRelationMapping(String name, TypeWrapper wrappedType) {
        this.name = name;
        super(name, wrappedType);
    }
}

