/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j;

import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.usefultoys.slf4j.LoggerOutputStream;
import org.usefultoys.slf4j.NullOutputStream;
import org.usefultoys.slf4j.NullPrintStream;

public final class LoggerFactory {
    private LoggerFactory() {
    }

    public static Logger getLogger(String string) {
        return org.slf4j.LoggerFactory.getILoggerFactory().getLogger(string);
    }

    public static Logger getLogger(Class<?> clazz) {
        return org.slf4j.LoggerFactory.getILoggerFactory().getLogger(clazz.getName());
    }

    public static Logger getLogger(Class<?> clazz, String string) {
        return org.slf4j.LoggerFactory.getILoggerFactory().getLogger(clazz.getName() + '.' + string);
    }

    public static Logger getLogger(Logger logger, String string) {
        return org.slf4j.LoggerFactory.getILoggerFactory().getLogger(logger.getName() + '.' + string);
    }

    public static PrintStream getTracePrintStream(Logger logger) {
        if (!logger.isTraceEnabled()) {
            return new NullPrintStream();
        }
        return new PrintStream(LoggerFactory.getTraceOutputStream(logger));
    }

    public static PrintStream getDebugPrintStream(Logger logger) {
        if (!logger.isDebugEnabled()) {
            return new NullPrintStream();
        }
        return new PrintStream(LoggerFactory.getDebugOutputStream(logger));
    }

    public static PrintStream getInfoPrintStream(Logger logger) {
        if (!logger.isInfoEnabled()) {
            return new NullPrintStream();
        }
        return new PrintStream(LoggerFactory.getInfoOutputStream(logger));
    }

    public static PrintStream getWarnPrintStream(Logger logger) {
        if (!logger.isWarnEnabled()) {
            return new NullPrintStream();
        }
        return new PrintStream(LoggerFactory.getWarnOutputStream(logger));
    }

    public static PrintStream getErrorPrintStream(Logger logger) {
        if (!logger.isErrorEnabled()) {
            return new NullPrintStream();
        }
        return new PrintStream(LoggerFactory.getErrorOutputStream(logger));
    }

    public static OutputStream getTraceOutputStream(final Logger logger) {
        if (!logger.isTraceEnabled()) {
            return new NullOutputStream();
        }
        return new LoggerOutputStream(){

            @Override
            protected void writeToLogger() {
                logger.trace(this.extractString());
            }
        };
    }

    public static OutputStream getDebugOutputStream(final Logger logger) {
        if (!logger.isDebugEnabled()) {
            return new NullOutputStream();
        }
        return new LoggerOutputStream(){

            @Override
            protected void writeToLogger() {
                logger.debug(this.extractString());
            }
        };
    }

    public static OutputStream getInfoOutputStream(final Logger logger) {
        if (!logger.isInfoEnabled()) {
            return new NullOutputStream();
        }
        return new LoggerOutputStream(){

            @Override
            protected void writeToLogger() {
                logger.info(this.extractString());
            }
        };
    }

    public static OutputStream getWarnOutputStream(final Logger logger) {
        if (!logger.isWarnEnabled()) {
            return new NullOutputStream();
        }
        return new LoggerOutputStream(){

            @Override
            protected void writeToLogger() {
                logger.warn(this.extractString());
            }
        };
    }

    public static OutputStream getErrorOutputStream(final Logger logger) {
        if (!logger.isErrorEnabled()) {
            return new NullOutputStream();
        }
        return new LoggerOutputStream(){

            @Override
            protected void writeToLogger() {
                logger.error(this.extractString());
            }
        };
    }

    public static PrintStream getTracePrintStream(Logger logger, String string) {
        return LoggerFactory.getTracePrintStream(LoggerFactory.getLogger(logger, string));
    }

    public static PrintStream getDebugPrintStream(Logger logger, String string) {
        return LoggerFactory.getDebugPrintStream(LoggerFactory.getLogger(logger, string));
    }

    public static PrintStream getInfoPrintStream(Logger logger, String string) {
        return LoggerFactory.getInfoPrintStream(LoggerFactory.getLogger(logger, string));
    }

    public static PrintStream getWarnPrintStream(Logger logger, String string) {
        return LoggerFactory.getWarnPrintStream(LoggerFactory.getLogger(logger, string));
    }

    public static PrintStream getErrorPrintStream(Logger logger, String string) {
        return LoggerFactory.getErrorPrintStream(LoggerFactory.getLogger(logger, string));
    }

    public static OutputStream getTraceOutputStream(Logger logger, String string) {
        return LoggerFactory.getTraceOutputStream(LoggerFactory.getLogger(logger, string));
    }

    public static OutputStream getDebugOutputStream(Logger logger, String string) {
        return LoggerFactory.getDebugOutputStream(LoggerFactory.getLogger(logger, string));
    }

    public static OutputStream getInfoOutputStream(Logger logger, String string) {
        return LoggerFactory.getInfoOutputStream(LoggerFactory.getLogger(logger, string));
    }

    public static OutputStream getWarnOutputStream(Logger logger, String string) {
        return LoggerFactory.getWarnOutputStream(LoggerFactory.getLogger(logger, string));
    }

    public static OutputStream getErrorOutputStream(Logger logger, String string) {
        return LoggerFactory.getErrorOutputStream(LoggerFactory.getLogger(logger, string));
    }
}

