/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.internal;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class EventReader {
    private boolean firstProperty = true;
    private boolean firstValue = true;
    private int start;
    private String charsString;
    private char[] chars;
    private int lenght;

    public EventReader reset(String string) {
        this.firstProperty = true;
        this.firstValue = true;
        this.chars = string.toCharArray();
        this.start = 0;
        this.lenght = this.chars.length;
        this.charsString = string;
        return this;
    }

    public boolean hasMore() {
        return this.start < this.lenght;
    }

    public String readPropertyName() throws IOException {
        if (!this.firstProperty) {
            this.readSymbol(';');
        } else {
            this.firstProperty = false;
        }
        this.firstValue = true;
        return this.readPropertyKey();
    }

    public String readString() throws IOException {
        if (this.firstValue) {
            this.readSymbol('=');
            this.firstValue = false;
        } else {
            this.readSymbol('|');
        }
        return this.readPropertyValue();
    }

    public boolean readBoolean() throws IOException {
        return Boolean.parseBoolean(this.readString());
    }

    public <T extends Enum<T>> T readEnum(Class<T> clazz) throws IOException {
        try {
            return Enum.valueOf(clazz, this.readString().toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("invalid enum", illegalArgumentException);
        }
    }

    public long readLong() throws IOException {
        try {
            return Long.parseLong(this.readString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("invalid long", numberFormatException);
        }
    }

    public long readLongOrZero() throws IOException {
        try {
            String string = this.readString();
            if (string.isEmpty()) {
                return 0L;
            }
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("invalid long", numberFormatException);
        }
    }

    public double readDouble() throws IOException {
        try {
            return Double.parseDouble(this.readString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("invalid double", numberFormatException);
        }
    }

    public double readDoubleOrZero() throws IOException {
        try {
            String string = this.readString();
            if (string.isEmpty()) {
                return 0.0;
            }
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("invalid double", numberFormatException);
        }
    }

    protected void readSymbol(char c) throws IOException {
        char c2;
        if (this.start >= this.lenght) {
            throw new EOFException();
        }
        if ((c2 = this.chars[this.start++]) != c) {
            throw new IOException("expected: " + c);
        }
    }

    protected boolean readOptionalSymbol(char c) throws IOException {
        if (this.start >= this.lenght) {
            throw new EOFException();
        }
        char c2 = this.chars[this.start];
        if (c2 == c) {
            ++this.start;
            return true;
        }
        return false;
    }

    public Map<String, String> readMap() throws IOException {
        if (this.firstValue) {
            this.readSymbol('=');
            this.firstValue = false;
        } else {
            this.readSymbol('|');
        }
        this.readSymbol('[');
        if (this.readOptionalSymbol(']')) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        do {
            String string = this.readMapKey();
            String string2 = null;
            if (this.readOptionalSymbol(':')) {
                string2 = this.readMapValue();
            }
            treeMap.put(string, string2);
        } while (this.readOptionalSymbol(','));
        this.readSymbol(']');
        return treeMap;
    }

    protected String readMapKey() throws IOException {
        if (this.start >= this.lenght) {
            throw new EOFException();
        }
        return this.readStringImp(':', ',', ']');
    }

    protected String readMapValue() throws IOException {
        if (this.start >= this.lenght) {
            throw new EOFException();
        }
        return this.readStringImp(',', ']', '\u0000');
    }

    protected String readPropertyValue() throws EOFException {
        if (this.start >= this.lenght) {
            throw new EOFException();
        }
        return this.readStringImp('|', ';', '\u0000');
    }

    protected String readPropertyKey() throws IOException {
        int n;
        if (this.start >= this.lenght) {
            throw new EOFException();
        }
        char c = this.chars[this.start];
        if (!Character.isJavaIdentifierStart(c) && c != '#') {
            throw new IOException("invalid identifier");
        }
        for (n = this.start + 1; n < this.lenght && Character.isJavaIdentifierPart(c = this.chars[n]); ++n) {
        }
        String string = this.charsString.substring(this.start, n);
        this.start = n;
        return string;
    }

    private String readStringImp(char c, char c2, char c3) throws EOFException {
        char c4;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = this.start; n < this.lenght && (c4 = this.chars[n]) != c && c4 != c2 && c4 != c3; ++n) {
            if (c4 != '\\') continue;
            stringBuilder.append(this.charsString.substring(this.start, n));
            if (++n >= this.lenght) {
                throw new EOFException();
            }
            this.start = n;
        }
        stringBuilder.append(this.charsString.substring(this.start, n));
        this.start = n;
        return stringBuilder.toString();
    }
}

