/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.meter;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.usefultoys.slf4j.LoggerConfig;
import org.usefultoys.slf4j.LoggerFactory;
import org.usefultoys.slf4j.Session;
import org.usefultoys.slf4j.meter.Markers;
import org.usefultoys.slf4j.meter.MeterConfig;
import org.usefultoys.slf4j.meter.MeterData;
import org.usefultoys.slf4j.watcher.WatcherConfig;

public class Meter
extends MeterData
implements Closeable {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION = "Meter cannot create exception of type {}.";
    private static final String ERROR_MSG_METER_ALREADY_STARTED = "Meter already started. id={}";
    private static final String ERROR_MSG_METER_ALREADY_STOPPED = "Meter already stopped. id={}";
    private static final String ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED = "Meter stopped but not started. id={}";
    private static final String ERROR_MSG_METER_STATED_AND_NEVER_STOPPED = "Meter started and never stopped. id={}";
    private static final String ERROR_MSG_METER_INCREMENTED_BUT_NOT_STARTED = "Meter incremented but not started. id={}";
    private static final String ERROR_MSG_METER_PROGRESS_BUT_NOT_STARTED = "Meter progress but not started. id={}";
    private static final String ERROR_MSG_METHOD_THREW_EXCEPTION = "Meter.{}(...) method threw exception. id={}";
    private static final String ERROR_MSG_ILLEGAL_ARGUMENT = "Illegal call to Meter.{}: {}. id={}";
    private static final String ERROR_MSG_METER_OUT_OF_ORDER = "Meter out of order. id={}";
    private static final String ERROR_MSG_NULL_ARGUMENT = "Null argument. id={}";
    private static final String ERROR_MSG_NON_POSITIVE_ARGUMENT = "Non positive argument";
    private static final String ERROR_MSG_ILLEGAL_STRING_FORMAT = "Illegal string format";
    private static final String ERROR_MSG_NON_FORWARD_ITERATION = "Non forward iteration";
    private static final String MY_CLASS_NAME = Meter.class.getName();
    private final transient Logger logger;
    private final transient Logger dataLogger;
    private final transient java.util.logging.Logger julLogger;
    private final transient java.util.logging.Logger julDataLogger;
    private static final String NULL_VALUE = "<null>";
    static final ConcurrentMap<String, AtomicLong> EVENT_COUNTER = new ConcurrentHashMap<String, AtomicLong>();
    private transient long lastProgressTime = 0L;
    private transient long lastProgressIteration = 0L;
    private static final ThreadLocal<WeakReference<Meter>> localThreadInstance = new ThreadLocal();
    private WeakReference<Meter> previousInstance;

    public Meter(Logger logger) {
        this(logger, null);
    }

    public Meter(Logger logger, String string) {
        this.logger = org.slf4j.LoggerFactory.getLogger((String)(MeterConfig.messagePrefix + logger.getName() + MeterConfig.messageSuffix));
        this.dataLogger = org.slf4j.LoggerFactory.getLogger((String)(MeterConfig.dataPrefix + logger.getName() + MeterConfig.dataSuffix));
        if (LoggerConfig.hackJulEnable) {
            this.julLogger = java.util.logging.Logger.getLogger(logger.getName());
            this.julDataLogger = java.util.logging.Logger.getLogger(this.dataLogger.getName());
        } else {
            this.julLogger = null;
            this.julDataLogger = null;
        }
        this.eventParent = null;
        this.eventCategory = logger.getName();
        this.eventName = string;
        this.eventPosition = Meter.extractNextPosition(this.eventCategory, this.eventName);
        this.createTime = System.nanoTime();
        this.sessionUuid = WatcherConfig.dataUuidSize == 0 ? null : Session.uuid.substring(Session.uuid.length() - WatcherConfig.dataUuidSize);
    }

    private static long extractNextPosition(String string, String string2) {
        String string3 = string2 == null ? string : string + "/" + string2;
        EVENT_COUNTER.putIfAbsent(string3, new AtomicLong(0L));
        AtomicLong atomicLong = (AtomicLong)EVENT_COUNTER.get(string3);
        atomicLong.compareAndSet(Long.MAX_VALUE, 0L);
        return atomicLong.incrementAndGet();
    }

    public static Meter getCurrentInstance() {
        Meter meter;
        WeakReference<Meter> weakReference = localThreadInstance.get();
        Meter meter2 = meter = weakReference == null ? null : (Meter)weakReference.get();
        if (meter == null) {
            return new Meter(LoggerFactory.getLogger("???"));
        }
        return meter;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Meter sub(String string) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"sub(name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
        }
        Meter meter = new Meter(this.logger, this.eventName == null ? string : this.eventName + '/' + string);
        meter.eventParent = this.getFullID();
        if (this.context != null) {
            meter.context = new HashMap(this.context);
        }
        return meter;
    }

    public Meter m(String string) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"m(message)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
        }
        this.description = string;
        return this;
    }

    public Meter m(String string, Object ... objectArray) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"m(message, args...)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            this.description = null;
            return this;
        }
        try {
            this.description = String.format(string, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"m(format, args...)", ERROR_MSG_ILLEGAL_STRING_FORMAT, this.getFullID(), new IllegalMeterUsage(2, (Throwable)illegalFormatException)});
        }
        return this;
    }

    public Meter limitMilliseconds(long l) {
        if (l <= 0L) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"limitMilliseconds(timeLimitMilliseconds)", ERROR_MSG_NON_POSITIVE_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        this.timeLimitNanoseconds = l * 1000L * 1000L;
        return this;
    }

    public Meter iterations(long l) {
        if (l <= 0L) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"iterations(expectedIterations)", ERROR_MSG_NON_POSITIVE_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        this.expectedIterations = l;
        return this;
    }

    public Meter ctx(String string) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, null);
        return this;
    }

    public Meter ctx(boolean bl, String string) {
        if (!bl) {
            return this;
        }
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(condition,name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, null);
        return this;
    }

    public Meter ctx(boolean bl, String string, String string2) {
        if (bl) {
            if (string == null) {
                this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(condition,name,name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
                return this;
            }
            if (this.context == null) {
                this.context = new LinkedHashMap();
            }
            this.context.put(string, null);
        } else {
            if (string2 == null) {
                this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(condition,name,name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
                return this;
            }
            if (this.context == null) {
                this.context = new LinkedHashMap();
            }
            this.context.put(string2, null);
        }
        return this;
    }

    public Meter ctx(String string, int n) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, Integer.toString(n));
        return this;
    }

    public Meter ctx(String string, long l) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, Long.toString(l));
        return this;
    }

    public Meter ctx(String string, boolean bl) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, Boolean.toString(bl));
        return this;
    }

    public Meter ctx(String string, float f) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, Float.toString(f));
        return this;
    }

    public Meter ctx(String string, double d) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, Double.toString(d));
        return this;
    }

    public Meter ctx(String string, Integer n) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, n == null ? NULL_VALUE : n.toString());
        return this;
    }

    public Meter ctx(String string, Long l) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, l == null ? NULL_VALUE : l.toString());
        return this;
    }

    public Meter ctx(String string, Boolean bl) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, bl == null ? NULL_VALUE : bl.toString());
        return this;
    }

    public Meter ctx(String string, Float f) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, f == null ? NULL_VALUE : f.toString());
        return this;
    }

    public Meter ctx(String string, Double d) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, d == null ? NULL_VALUE : d.toString());
        return this;
    }

    public Meter ctx(String string, Object object) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, object == null ? NULL_VALUE : object.toString());
        return this;
    }

    public Meter ctx(String string, String string2) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, string2 == null ? NULL_VALUE : string2);
        return this;
    }

    public Meter ctx(String string, String string2, Object ... objectArray) {
        if (string == null || string2 == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, format, args...)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        try {
            this.ctx(string, String.format(string2, objectArray));
        }
        catch (IllegalFormatException illegalFormatException) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, format, args...)", ERROR_MSG_ILLEGAL_STRING_FORMAT, this.getFullID(), new IllegalMeterUsage(2, (Throwable)illegalFormatException)});
        }
        return this;
    }

    public Meter unctx(String string) {
        if (string == null) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"unctx(name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            return this;
        }
        this.context.remove(string);
        return this;
    }

    public Meter start() {
        try {
            if (this.startTime != 0L) {
                this.logger.error(Markers.INCONSISTENT_START, ERROR_MSG_METER_ALREADY_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else {
                this.previousInstance = localThreadInstance.get();
                localThreadInstance.set(new WeakReference<Meter>(this));
            }
            this.lastProgressTime = this.startTime = System.nanoTime();
            if (this.logger.isDebugEnabled()) {
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                if (LoggerConfig.hackJulEnable) {
                    this.julLogger.log(Meter.startDebugStatusLogRecord(Markers.MSG_START, this.readableWrite()));
                } else {
                    this.logger.debug(Markers.MSG_START, this.readableWrite());
                }
                if (this.dataLogger.isTraceEnabled()) {
                    String string = this.write();
                    if (LoggerConfig.hackJulEnable) {
                        this.julDataLogger.log(Meter.startTraceStatusLogRecord(Markers.DATA_START, string));
                    } else {
                        this.dataLogger.trace(Markers.DATA_START, string);
                    }
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"start", this.getFullID(), exception});
        }
        return this;
    }

    public Meter inc() {
        if (this.startTime == 0L) {
            this.logger.error(Markers.INCONSISTENT_INCREMENT, ERROR_MSG_METER_INCREMENTED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(4));
        }
        ++this.iteration;
        return this;
    }

    public Meter incBy(long l) {
        if (this.startTime == 0L) {
            this.logger.error(Markers.INCONSISTENT_INCREMENT, ERROR_MSG_METER_INCREMENTED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(4));
        }
        if (l <= 0L) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"incBy(increment)", ERROR_MSG_NON_POSITIVE_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        this.iteration += l;
        return this;
    }

    public Meter incTo(long l) {
        if (this.startTime == 0L) {
            this.logger.error(Markers.INCONSISTENT_INCREMENT, ERROR_MSG_METER_INCREMENTED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(4));
        }
        if (l <= 0L) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"incTo(currentIteration)", ERROR_MSG_NON_POSITIVE_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (l <= this.iteration) {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"incTo(currentIteration)", ERROR_MSG_NON_FORWARD_ITERATION, this.getFullID(), new IllegalMeterUsage(2)});
        }
        this.iteration = l;
        return this;
    }

    public Meter progress() {
        try {
            long l;
            if (this.startTime == 0L) {
                this.logger.error(Markers.INCONSISTENT_PROGRESS, ERROR_MSG_METER_PROGRESS_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            long l2 = MeterConfig.progressPeriodMilliseconds * 1000L * 1000L;
            if (this.iteration > this.lastProgressIteration && (l = System.nanoTime()) - this.lastProgressTime > l2) {
                this.lastProgressIteration = this.iteration;
                this.lastProgressTime = l;
                if (this.logger.isInfoEnabled()) {
                    this.collectRuntimeStatus();
                    this.collectPlatformStatus();
                    this.logger.info(Markers.MSG_PROGRESS, this.readableWrite());
                    if (this.dataLogger.isTraceEnabled()) {
                        String string = this.write();
                        if (this.startTime != 0L && this.timeLimitNanoseconds != 0L && l - this.startTime > this.timeLimitNanoseconds) {
                            if (LoggerConfig.hackJulEnable) {
                                this.julDataLogger.log(Meter.progressTraceStatusLogRecord(Markers.DATA_SLOW_PROGRESS, string));
                            } else {
                                this.dataLogger.trace(Markers.DATA_SLOW_PROGRESS, string);
                            }
                        } else if (this.dataLogger.isTraceEnabled()) {
                            if (LoggerConfig.hackJulEnable) {
                                this.julDataLogger.log(Meter.progressTraceStatusLogRecord(Markers.DATA_PROGRESS, string));
                            } else {
                                this.dataLogger.trace(Markers.DATA_PROGRESS, string);
                            }
                        }
                    }
                    if (this.context != null) {
                        this.context.clear();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"progress", this.getFullID(), exception});
        }
        return this;
    }

    @Deprecated
    public Meter flow(Object object) {
        return this.path(object);
    }

    public Meter path(Object object) {
        if (object instanceof String) {
            this.pathId = (String)object;
        } else if (object instanceof Enum) {
            this.pathId = ((Enum)object).name();
        } else if (object instanceof Throwable) {
            this.pathId = object.getClass().getSimpleName();
        } else if (object != null) {
            this.pathId = object.toString();
        } else {
            this.logger.error(Markers.ILLEGAL, ERROR_MSG_NULL_ARGUMENT, (Object)this.getFullID(), (Object)new IllegalMeterUsage(4));
        }
        return this;
    }

    public Meter ok() {
        try {
            long l = System.nanoTime();
            if (this.stopTime != 0L) {
                this.logger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_ALREADY_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.checkCurrentInstance()) {
                this.logger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_OUT_OF_ORDER, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.startTime == 0L) {
                this.logger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            this.stopTime = l;
            this.failClass = null;
            this.failMessage = null;
            this.rejectId = null;
            localThreadInstance.set(this.previousInstance);
            if (this.logger.isWarnEnabled()) {
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                boolean bl = this.startTime != 0L && this.timeLimitNanoseconds != 0L && this.stopTime - this.startTime > this.timeLimitNanoseconds;
                String string = this.readableWrite();
                if (bl) {
                    if (LoggerConfig.hackJulEnable) {
                        this.julLogger.log(Meter.okWarnLogRecord(Markers.MSG_SLOW_OK, string));
                    } else {
                        this.logger.warn(Markers.MSG_SLOW_OK, string);
                    }
                } else if (this.logger.isInfoEnabled()) {
                    if (LoggerConfig.hackJulEnable) {
                        this.julLogger.log(Meter.okInfoStausLogRecord(Markers.MSG_OK, string));
                    } else {
                        this.logger.info(Markers.MSG_OK, string);
                    }
                }
                if (this.dataLogger.isTraceEnabled()) {
                    String string2 = this.write();
                    if (bl) {
                        if (LoggerConfig.hackJulEnable) {
                            this.julDataLogger.log(Meter.okTraceStatusLogRecord(Markers.DATA_SLOW_OK, string2));
                        } else {
                            this.dataLogger.trace(Markers.DATA_SLOW_OK, string2);
                        }
                    } else if (LoggerConfig.hackJulEnable) {
                        this.julDataLogger.log(Meter.okTraceStatusLogRecord(Markers.DATA_OK, string2));
                    } else {
                        this.dataLogger.trace(Markers.DATA_OK, string2);
                    }
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"ok", this.getFullID(), exception});
        }
        return this;
    }

    public boolean checkCurrentInstance() {
        WeakReference<Meter> weakReference = localThreadInstance.get();
        return weakReference == null || weakReference.get() != this;
    }

    public Meter ok(Object object) {
        try {
            long l = System.nanoTime();
            if (this.stopTime != 0L) {
                this.logger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_ALREADY_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.checkCurrentInstance()) {
                this.logger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_OUT_OF_ORDER, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.startTime == 0L) {
                this.logger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            this.stopTime = l;
            this.failClass = null;
            this.failMessage = null;
            this.rejectId = null;
            localThreadInstance.set(this.previousInstance);
            if (object instanceof String) {
                this.pathId = (String)object;
            } else if (object instanceof Enum) {
                this.pathId = ((Enum)object).name();
            } else if (object instanceof Throwable) {
                this.pathId = object.getClass().getSimpleName();
            } else if (object != null) {
                this.pathId = object.toString();
            } else {
                this.logger.error(Markers.INCONSISTENT_OK, ERROR_MSG_NULL_ARGUMENT, (Object)this.getFullID(), (Object)new IllegalMeterUsage(4));
            }
            if (this.logger.isWarnEnabled()) {
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                boolean bl = this.startTime != 0L && this.timeLimitNanoseconds != 0L && this.stopTime - this.startTime > this.timeLimitNanoseconds;
                String string = this.readableWrite();
                if (bl) {
                    if (LoggerConfig.hackJulEnable) {
                        this.julLogger.log(Meter.okWarnLogRecord(Markers.MSG_SLOW_OK, string));
                    } else {
                        this.logger.warn(Markers.MSG_SLOW_OK, string);
                    }
                } else if (this.logger.isInfoEnabled()) {
                    if (LoggerConfig.hackJulEnable) {
                        this.julLogger.log(Meter.okInfoStausLogRecord(Markers.MSG_OK, string));
                    } else {
                        this.logger.info(Markers.MSG_OK, string);
                    }
                }
                if (this.dataLogger.isTraceEnabled()) {
                    String string2 = this.write();
                    if (bl) {
                        if (LoggerConfig.hackJulEnable) {
                            this.julDataLogger.log(Meter.okTraceStatusLogRecord(Markers.DATA_SLOW_OK, string2));
                        } else {
                            this.dataLogger.trace(Markers.DATA_SLOW_OK, string2);
                        }
                    } else if (LoggerConfig.hackJulEnable) {
                        this.julDataLogger.log(Meter.okTraceStatusLogRecord(Markers.DATA_OK, string2));
                    } else {
                        this.dataLogger.trace(Markers.DATA_OK, string2);
                    }
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"ok", this.getFullID(), exception});
        }
        return this;
    }

    public Meter reject(Object object) {
        try {
            long l = System.nanoTime();
            if (this.stopTime != 0L) {
                this.logger.error(Markers.INCONSISTENT_REJECT, ERROR_MSG_METER_ALREADY_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.checkCurrentInstance()) {
                this.logger.error(Markers.INCONSISTENT_REJECT, ERROR_MSG_METER_OUT_OF_ORDER, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.startTime == 0L) {
                this.logger.error(Markers.INCONSISTENT_REJECT, ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            this.stopTime = l;
            this.failClass = null;
            this.failMessage = null;
            this.pathId = null;
            localThreadInstance.set(this.previousInstance);
            if (object instanceof String) {
                this.rejectId = (String)object;
            } else if (object instanceof Enum) {
                this.rejectId = ((Enum)object).name();
            } else if (object instanceof Throwable) {
                this.rejectId = object.getClass().getSimpleName();
            } else if (object != null) {
                this.rejectId = object.toString();
            } else {
                this.logger.error(Markers.INCONSISTENT_REJECT, ERROR_MSG_NULL_ARGUMENT, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            if (this.logger.isInfoEnabled()) {
                String string;
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                if (this.logger.isInfoEnabled()) {
                    string = this.readableWrite();
                    if (LoggerConfig.hackJulEnable) {
                        this.julLogger.log(Meter.rejectInfoStausLogRecord(Markers.MSG_REJECT, string));
                    } else {
                        this.logger.info(Markers.MSG_REJECT, string);
                    }
                }
                if (this.dataLogger.isTraceEnabled()) {
                    string = this.write();
                    if (LoggerConfig.hackJulEnable) {
                        this.julDataLogger.log(Meter.rejectTraceStatusLogRecord(Markers.DATA_REJECT, string));
                    } else {
                        this.dataLogger.trace(Markers.DATA_REJECT, string);
                    }
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"reject", this.getFullID(), exception});
        }
        return this;
    }

    public Meter fail(Throwable throwable) {
        try {
            long l = System.nanoTime();
            if (this.stopTime != 0L) {
                this.logger.error(Markers.INCONSISTENT_FAIL, ERROR_MSG_METER_ALREADY_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.checkCurrentInstance()) {
                this.logger.error(Markers.INCONSISTENT_FAIL, ERROR_MSG_METER_OUT_OF_ORDER, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.startTime == 0L) {
                this.logger.error(Markers.INCONSISTENT_FAIL, ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            this.stopTime = l;
            this.rejectId = null;
            this.pathId = null;
            localThreadInstance.set(this.previousInstance);
            if (throwable instanceof TryWithResourcesFailed) {
                this.failClass = null;
                this.failMessage = "try-with-resources";
            } else if (throwable != null) {
                this.failClass = throwable.getClass().getName();
                this.failMessage = throwable.getLocalizedMessage();
            } else {
                this.logger.error(Markers.INCONSISTENT_FAIL, ERROR_MSG_NULL_ARGUMENT, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            if (this.logger.isErrorEnabled()) {
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                String string = this.readableWrite();
                if (LoggerConfig.hackJulEnable) {
                    this.julLogger.log(Meter.failErrorStatusLogRecord(Markers.MSG_FAIL, string, throwable));
                } else {
                    this.logger.error(Markers.MSG_FAIL, string, throwable);
                }
                if (this.dataLogger.isTraceEnabled()) {
                    String string2 = this.write();
                    if (LoggerConfig.hackJulEnable) {
                        this.julDataLogger.log(Meter.failTraceStatusLogRecord(Markers.DATA_FAIL, string2));
                    } else {
                        this.dataLogger.trace(Markers.DATA_FAIL, string2);
                    }
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"fail", this.getFullID(), exception});
        }
        return this;
    }

    protected void finalize() throws Throwable {
        if (this.stopTime == 0L) {
            this.logger.error(Markers.INCONSISTENT_FINALIZED, ERROR_MSG_METER_STATED_AND_NEVER_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(1));
        }
        super.finalize();
    }

    @Override
    public void close() {
        if (this.stopTime == 0L) {
            this.fail(new TryWithResourcesFailed(2));
        }
    }

    public void run(Runnable runnable) {
        this.start();
        try {
            runnable.run();
            this.ok();
        }
        catch (RuntimeException runtimeException) {
            this.fail(runtimeException);
            throw runtimeException;
        }
    }

    public <T> T call(Callable<T> callable) throws Exception {
        this.start();
        try {
            T t = callable.call();
            this.ctx("result", t).ok();
            return t;
        }
        catch (Exception exception) {
            this.fail(exception);
            throw exception;
        }
    }

    public <T> T safeCall(Callable<T> callable) {
        this.start();
        try {
            T t = callable.call();
            this.ctx("result", t).ok();
            return t;
        }
        catch (RuntimeException runtimeException) {
            this.fail(runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            this.fail(exception);
            throw new RuntimeException(exception);
        }
    }

    public <E extends RuntimeException, T> T safeCall(Class<E> clazz, Callable<T> callable) {
        this.start();
        try {
            T t = callable.call();
            this.ok();
            return t;
        }
        catch (RuntimeException runtimeException) {
            this.fail(runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            this.fail(exception);
            throw this.convertException(clazz, exception);
        }
    }

    private <T extends RuntimeException> RuntimeException convertException(Class<T> clazz, Exception exception) {
        String string = "Failed: " + (this.description != null ? this.description : this.eventCategory);
        try {
            return (RuntimeException)clazz.getConstructor(String.class, Throwable.class).newInstance(string, exception);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        catch (SecurityException securityException) {
            this.logger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        catch (InstantiationException instantiationException) {
            this.logger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        return new RuntimeException(exception);
    }

    private static LogRecord startDebugStatusLogRecord(Marker marker, String string) {
        LogRecord logRecord = new LogRecord(Level.FINE, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("start");
        }
        return logRecord;
    }

    private static LogRecord startTraceStatusLogRecord(Marker marker, String string) {
        LogRecord logRecord = new LogRecord(Level.FINEST, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("start");
        }
        return logRecord;
    }

    private static LogRecord okTraceStatusLogRecord(Marker marker, String string) {
        LogRecord logRecord = new LogRecord(Level.FINEST, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("ok");
        }
        return logRecord;
    }

    private static LogRecord rejectTraceStatusLogRecord(Marker marker, String string) {
        LogRecord logRecord = new LogRecord(Level.FINEST, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("reject");
        }
        return logRecord;
    }

    private static LogRecord failTraceStatusLogRecord(Marker marker, String string) {
        LogRecord logRecord = new LogRecord(Level.FINEST, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("fail");
        }
        return logRecord;
    }

    private static LogRecord failErrorStatusLogRecord(Marker marker, String string, Throwable throwable) {
        LogRecord logRecord = new LogRecord(Level.FINEST, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        logRecord.setThrown(throwable);
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("fail");
        }
        return logRecord;
    }

    private static LogRecord progressTraceStatusLogRecord(Marker marker, String string) {
        LogRecord logRecord = new LogRecord(Level.FINEST, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("progress");
        }
        return logRecord;
    }

    private static LogRecord progressInfoStausLogRecord(Marker marker, String string) {
        LogRecord logRecord = new LogRecord(Level.INFO, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("progress");
        }
        return logRecord;
    }

    private static LogRecord rejectInfoStausLogRecord(Marker marker, String string) {
        LogRecord logRecord = new LogRecord(Level.INFO, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("reject");
        }
        return logRecord;
    }

    private static LogRecord okInfoStausLogRecord(Marker marker, String string) {
        LogRecord logRecord = new LogRecord(Level.INFO, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("ok");
        }
        return logRecord;
    }

    private static LogRecord okWarnLogRecord(Marker marker, String string) {
        LogRecord logRecord = new LogRecord(Level.WARNING, "[{0}] {1}");
        logRecord.setParameters(new Object[]{marker.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("ok");
        }
        return logRecord;
    }

    public static class TryWithResourcesFailed
    extends MeterThrowable {
        private static final long serialVersionUID = 1L;

        TryWithResourcesFailed(int n) {
            super(n);
        }
    }

    public static class IllegalMeterUsage
    extends MeterThrowable {
        private static final long serialVersionUID = 1L;

        IllegalMeterUsage(int n) {
            super(n);
        }

        IllegalMeterUsage(int n, Throwable throwable) {
            super(n, throwable);
        }
    }

    public static class MeterThrowable
    extends Throwable {
        private static final long serialVersionUID = 1L;

        MeterThrowable(int n) {
            this(n + 1, null);
        }

        MeterThrowable(int n, Throwable throwable) {
            super(throwable);
            ++n;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            while (MY_CLASS_NAME.equals(stackTraceElementArray[n].getClassName())) {
                ++n;
            }
            stackTraceElementArray = Arrays.copyOfRange(stackTraceElementArray, n, stackTraceElementArray.length);
            this.setStackTrace(stackTraceElementArray);
        }

        MeterThrowable() {
            super("Illegal Meter usage.");
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

