/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.meter;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.usefultoys.slf4j.internal.EventData;
import org.usefultoys.slf4j.internal.EventReader;
import org.usefultoys.slf4j.internal.EventWriter;
import org.usefultoys.slf4j.internal.SystemData;
import org.usefultoys.slf4j.meter.MeterConfig;
import org.usefultoys.slf4j.utils.UnitFormatter;

public class MeterData
extends SystemData {
    private static final long serialVersionUID = 2L;
    public static final char DETAILED_MESSAGE_PREFIX = 'M';
    protected String eventCategory = null;
    protected String eventName = null;
    protected String eventParent = null;
    protected String description = null;
    protected String pathId;
    protected String rejectId;
    protected long createTime = 0L;
    protected long startTime = 0L;
    protected long stopTime = 0L;
    protected long iteration = 0L;
    protected long expectedIterations = 0L;
    protected String failClass = null;
    protected String failMessage = null;
    protected long timeLimitNanoseconds = 0L;
    protected Map<String, String> context;
    public static final String PROP_DESCRIPTION = "d";
    public static final String PROP_PATH_ID = "p";
    public static final String PROP_REJECT_ID = "r";
    public static final String PROP_FAIL_ID = "f";
    public static final String PROP_CREATE_TIME = "t0";
    public static final String PROP_START_TIME = "t1";
    public static final String PROP_STOP_TIME = "t2";
    public static final String PROP_ITERATION = "i";
    public static final String PROP_EXPECTED_ITERATION = "ei";
    public static final String PROP_LIMIT_TIME = "tl";
    public static final String PROP_CONTEXT = "ctx";
    public static final String EVENT_CATEGORY = "c";
    public static final String EVENT_NAME = "n";
    public static final String EVENT_PARENT = "ep";

    public String getFullID() {
        if (this.eventName == null) {
            return this.eventCategory + '/' + this.eventPosition;
        }
        return this.eventCategory + '/' + this.eventName + '#' + this.eventPosition;
    }

    public String getEventCategory() {
        return this.eventCategory;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventParent() {
        return this.eventParent;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPathId() {
        return this.pathId;
    }

    public String getRejectId() {
        return this.rejectId;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public long getCurrentIteration() {
        return this.iteration;
    }

    public long getExpectedIterations() {
        return this.expectedIterations;
    }

    public String getExceptionClass() {
        return this.failClass;
    }

    public String getExceptionMessage() {
        return this.failMessage;
    }

    public boolean isStarted() {
        return this.startTime != 0L;
    }

    public boolean isStopped() {
        return this.stopTime != 0L;
    }

    public boolean isOK() {
        return this.stopTime != 0L && this.failClass == null && this.rejectId == null;
    }

    public boolean isReject() {
        return this.stopTime != 0L && this.rejectId != null;
    }

    public boolean isFail() {
        return this.stopTime != 0L && this.failClass != null;
    }

    public long getTimeLimitNanoseconds() {
        return this.timeLimitNanoseconds;
    }

    public Map<String, String> getContext() {
        if (this.context == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.context);
    }

    @Override
    protected void resetImpl() {
        super.resetImpl();
        this.eventCategory = null;
        this.eventName = null;
        this.eventParent = null;
        this.description = null;
        this.pathId = null;
        this.rejectId = null;
        this.createTime = 0L;
        this.startTime = 0L;
        this.stopTime = 0L;
        this.iteration = 0L;
        this.expectedIterations = 0L;
        this.failClass = null;
        this.failMessage = null;
        this.timeLimitNanoseconds = 0L;
        this.context = null;
    }

    @Override
    protected boolean isCompletelyEqualsImpl(EventData eventData) {
        MeterData meterData = (MeterData)eventData;
        if (this.description == null ? meterData.description != null : !this.description.equals(meterData.description)) {
            return false;
        }
        if (this.eventCategory == null ? meterData.eventCategory != null : !this.eventCategory.equals(meterData.eventCategory)) {
            return false;
        }
        if (this.eventName == null ? meterData.eventName != null : !this.eventName.equals(meterData.eventName)) {
            return false;
        }
        if (this.eventParent == null ? meterData.eventParent != null : !this.eventParent.equals(meterData.eventParent)) {
            return false;
        }
        if (this.pathId == null ? meterData.pathId != null : !this.pathId.equals(meterData.pathId)) {
            return false;
        }
        if (this.rejectId == null ? meterData.rejectId != null : !this.rejectId.equals(meterData.rejectId)) {
            return false;
        }
        if (this.createTime != meterData.createTime) {
            return false;
        }
        if (this.startTime != meterData.startTime) {
            return false;
        }
        if (this.stopTime != meterData.stopTime) {
            return false;
        }
        if (this.iteration != meterData.iteration) {
            return false;
        }
        if (this.expectedIterations != meterData.expectedIterations) {
            return false;
        }
        if (this.failClass == null ? meterData.failClass != null : !this.failClass.equals(meterData.failClass)) {
            return false;
        }
        if (this.failMessage == null ? meterData.failMessage != null : !this.failMessage.equals(meterData.failMessage)) {
            return false;
        }
        if (this.timeLimitNanoseconds != meterData.timeLimitNanoseconds) {
            return false;
        }
        if (!(this.context == meterData.context || this.context != null && this.context.equals(meterData.context))) {
            return false;
        }
        return super.isCompletelyEqualsImpl(eventData);
    }

    @Override
    public StringBuilder readableString(StringBuilder stringBuilder) {
        if (MeterConfig.printStatus) {
            if (this.stopTime != 0L) {
                if (this.failClass == null && this.rejectId == null) {
                    if (this.timeLimitNanoseconds != 0L && this.startTime != 0L && this.stopTime - this.startTime > this.timeLimitNanoseconds) {
                        stringBuilder.append("OK (Slow)");
                    } else {
                        stringBuilder.append("OK");
                    }
                } else if (this.rejectId != null) {
                    stringBuilder.append("REJECT");
                } else if (this.failClass != null) {
                    stringBuilder.append("FAIL");
                }
            } else if (this.startTime != 0L && this.iteration == 0L) {
                stringBuilder.append("Started");
            } else if (this.startTime != 0L) {
                stringBuilder.append("Progress ");
            } else {
                stringBuilder.append("Scheduled");
            }
            stringBuilder.append(": ");
        }
        if (MeterConfig.printCategory) {
            int n = this.eventCategory.lastIndexOf(46) + 1;
            stringBuilder.append(this.eventCategory.substring(n));
        }
        if (this.eventName != null) {
            if (MeterConfig.printCategory) {
                stringBuilder.append('/');
            }
            stringBuilder.append(this.eventName);
        }
        if (MeterConfig.printPosition) {
            stringBuilder.append('#');
            stringBuilder.append(this.eventPosition);
        }
        if (this.pathId != null) {
            stringBuilder.append(" [");
            stringBuilder.append(this.pathId);
            stringBuilder.append(']');
        }
        if (this.rejectId != null) {
            stringBuilder.append(" [");
            stringBuilder.append(this.rejectId);
            stringBuilder.append(']');
        }
        if (this.failClass != null || this.failMessage != null) {
            stringBuilder.append(" [");
            if (this.failClass != null) {
                stringBuilder.append(this.failClass);
            }
            if (this.failClass != null && this.failMessage != null) {
                stringBuilder.append("; ");
            }
            if (this.failMessage != null) {
                stringBuilder.append(this.failMessage);
            }
            stringBuilder.append(']');
        }
        if (this.startTime != 0L && this.iteration > 0L) {
            stringBuilder.append(' ');
            stringBuilder.append(UnitFormatter.iterations(this.iteration));
            if (this.expectedIterations > 0L) {
                stringBuilder.append('/');
                stringBuilder.append(UnitFormatter.iterations(this.expectedIterations));
            }
        }
        if (this.description != null) {
            stringBuilder.append(" '");
            stringBuilder.append(this.description);
            stringBuilder.append('\'');
        }
        if (this.startTime != 0L) {
            stringBuilder.append("; ");
            stringBuilder.append(UnitFormatter.nanoseconds(this.getExecutionTime()));
            if (this.iteration > 0L) {
                stringBuilder.append("; ");
                double d = this.getIterationsPerSecond();
                stringBuilder.append(UnitFormatter.iterationsPerSecond(d));
                stringBuilder.append(' ');
                double d2 = 1.0 / d * 1.0E9;
                stringBuilder.append(UnitFormatter.nanoseconds(d2));
            }
        } else {
            stringBuilder.append("; ");
            stringBuilder.append(UnitFormatter.nanoseconds(this.getWaitingTime()));
        }
        if (this.runtime_usedMemory > 0L) {
            stringBuilder.append("; ");
            stringBuilder.append(UnitFormatter.bytes(this.runtime_usedMemory));
        }
        if (this.systemLoad > 0.0) {
            stringBuilder.append("; ");
            stringBuilder.append(Math.round(this.systemLoad * 100.0));
            stringBuilder.append("%");
        }
        if (this.context != null) {
            for (Map.Entry<String, String> entry : this.context.entrySet()) {
                stringBuilder.append("; ");
                stringBuilder.append(entry.getKey());
                if (entry.getValue() == null) continue;
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
            }
        }
        return stringBuilder;
    }

    public boolean isSlow() {
        return this.timeLimitNanoseconds != 0L && this.stopTime != 0L && this.startTime != 0L && this.stopTime - this.startTime > this.timeLimitNanoseconds;
    }

    public long getExecutionTime() {
        if (this.startTime == 0L) {
            return 0L;
        }
        if (this.stopTime == 0L) {
            return System.nanoTime() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    public long getWaitingTime() {
        if (this.startTime == 0L) {
            return System.nanoTime() - this.createTime;
        }
        return this.startTime - this.createTime;
    }

    public double getIterationsPerSecond() {
        if (this.iteration == 0L || this.startTime == 0L) {
            return 0.0;
        }
        float f = this.getExecutionTime();
        if (f == 0.0f) {
            return 0.0;
        }
        return (double)this.iteration / (double)f * 1.0E9;
    }

    @Override
    public void writePropertiesImpl(EventWriter eventWriter) {
        if (this.description != null) {
            eventWriter.property(PROP_DESCRIPTION, this.description);
        }
        if (this.rejectId != null) {
            eventWriter.property(PROP_REJECT_ID, this.rejectId);
        }
        if (this.pathId != null) {
            eventWriter.property(PROP_PATH_ID, this.pathId);
        }
        if (this.failClass != null) {
            eventWriter.property(PROP_FAIL_ID, this.failClass, this.failMessage != null ? this.failMessage : "");
        }
        if (this.eventCategory != null) {
            eventWriter.property(EVENT_CATEGORY, this.eventCategory);
        }
        if (this.eventName != null) {
            eventWriter.property(EVENT_NAME, this.eventName);
        }
        if (this.eventParent != null) {
            eventWriter.property(EVENT_PARENT, this.eventParent);
        }
        if (this.createTime != 0L) {
            eventWriter.property(PROP_CREATE_TIME, this.createTime);
        }
        if (this.startTime != 0L) {
            eventWriter.property(PROP_START_TIME, this.startTime);
        }
        if (this.stopTime != 0L) {
            eventWriter.property(PROP_STOP_TIME, this.stopTime);
        }
        if (this.iteration != 0L) {
            eventWriter.property(PROP_ITERATION, this.iteration);
        }
        if (this.expectedIterations != 0L) {
            eventWriter.property(PROP_EXPECTED_ITERATION, this.expectedIterations);
        }
        if (this.timeLimitNanoseconds != 0L) {
            eventWriter.property(PROP_LIMIT_TIME, this.timeLimitNanoseconds);
        }
        if (this.context != null && !this.context.isEmpty()) {
            eventWriter.property(PROP_CONTEXT, this.context);
        }
        super.writePropertiesImpl(eventWriter);
    }

    @Override
    protected boolean readPropertyImpl(EventReader eventReader, String string) throws IOException {
        if (PROP_DESCRIPTION.equals(string)) {
            this.description = eventReader.readString();
            return true;
        }
        if (EVENT_CATEGORY.equals(string)) {
            this.eventCategory = eventReader.readString();
            return true;
        }
        if (EVENT_NAME.equals(string)) {
            this.eventName = eventReader.readString();
            return true;
        }
        if (EVENT_PARENT.equals(string)) {
            this.eventParent = eventReader.readString();
            return true;
        }
        if (PROP_FAIL_ID.equals(string)) {
            this.failClass = eventReader.readString();
            this.failMessage = eventReader.readString();
            return true;
        }
        if (PROP_REJECT_ID.equals(string)) {
            this.rejectId = eventReader.readString();
            return true;
        }
        if (PROP_PATH_ID.equals(string)) {
            this.pathId = eventReader.readString();
            return true;
        }
        if (PROP_CREATE_TIME.equals(string)) {
            this.createTime = eventReader.readLong();
            return true;
        }
        if (PROP_START_TIME.equals(string)) {
            this.startTime = eventReader.readLong();
            return true;
        }
        if (PROP_STOP_TIME.equals(string)) {
            this.stopTime = eventReader.readLong();
            return true;
        }
        if (PROP_ITERATION.equals(string)) {
            this.iteration = eventReader.readLong();
            return true;
        }
        if (PROP_EXPECTED_ITERATION.equals(string)) {
            this.expectedIterations = eventReader.readLong();
            return true;
        }
        if (PROP_LIMIT_TIME.equals(string)) {
            this.timeLimitNanoseconds = eventReader.readLong();
            return true;
        }
        if (PROP_CONTEXT.equals(string)) {
            this.context = eventReader.readMap();
            return true;
        }
        return super.readPropertyImpl(eventReader, string);
    }

    public final boolean read(String string) {
        return this.read(string, 'M');
    }

    public final String write() {
        return this.write(new StringBuilder(), 'M').toString();
    }

    public final String readableWrite() {
        return this.readableString(new StringBuilder()).toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MeterData meterData = (MeterData)object;
        if (this.eventCategory != null ? !this.eventCategory.equals(meterData.eventCategory) : meterData.eventCategory != null) {
            return false;
        }
        if (this.sessionUuid != null ? !this.sessionUuid.equals(meterData.sessionUuid) : meterData.sessionUuid != null) {
            return false;
        }
        if (this.eventPosition != meterData.eventPosition) {
            return false;
        }
        return this.eventName != null ? this.eventName.equals(meterData.eventName) : meterData.eventName == null;
    }

    public int hashCode() {
        int n = this.eventCategory != null ? this.eventCategory.hashCode() : 0;
        n = 31 * n + (this.eventName != null ? this.eventName.hashCode() : 0);
        n = 31 * n + (int)(this.eventPosition ^ this.eventPosition >>> 32);
        n = 31 * n + (this.sessionUuid != null ? this.sessionUuid.hashCode() : 0);
        return n;
    }
}

