/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.report;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.usefultoys.slf4j.LoggerFactory;

public class JdbcConnectionReporter {
    private final Logger logger;
    private boolean printTypeMap;

    public JdbcConnectionReporter(Logger logger) {
        this.logger = logger;
    }

    public JdbcConnectionReporter printTypeMap(boolean bl) {
        this.printTypeMap = bl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Connection connection) {
        PrintStream printStream = LoggerFactory.getInfoPrintStream(this.logger);
        printStream.println("JDBC connection");
        try {
            if (connection.isClosed()) {
                printStream.println(" - Closed! ");
                return;
            }
            if (connection.getCatalog() != null) {
                printStream.println(" - catalog: " + connection.getCatalog());
            }
            try {
                if (connection.getSchema() != null) {
                    printStream.println(" - schema: " + connection.getSchema());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData != null) {
                printStream.println("    URL: " + databaseMetaData.getURL());
                printStream.println("    user name: " + databaseMetaData.getUserName());
            }
            printStream.print(" - properties: ");
            if (connection.isReadOnly()) {
                printStream.print("read-only; ");
            }
            if (connection.getAutoCommit()) {
                printStream.print("auto-commit; ");
            }
            printStream.print("holdability=");
            switch (connection.getHoldability()) {
                case 1: {
                    printStream.print("hold-cursors-over-commit; ");
                    break;
                }
                case 2: {
                    printStream.print("close-cursors-at-commit; ");
                    break;
                }
                default: {
                    printStream.print("unknown; ");
                }
            }
            try {
                printStream.print("timeout=" + connection.getNetworkTimeout() + "ms; ");
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            printStream.print("transaction=");
            switch (connection.getTransactionIsolation()) {
                case 1: {
                    printStream.print("read-uncommited; ");
                    break;
                }
                case 2: {
                    printStream.print("read-commited; ");
                    break;
                }
                case 4: {
                    printStream.print("repeatable-read; ");
                    break;
                }
                case 8: {
                    printStream.print("serializable; ");
                    break;
                }
                case 0: {
                    printStream.print("none; ");
                    break;
                }
                default: {
                    printStream.print("unknown; ");
                }
            }
            printStream.println();
            printStream.print(" - client info: ");
            Properties properties = connection.getClientInfo();
            if (properties == null || properties.isEmpty()) {
                printStream.println("n/a");
            } else {
                int n = 1;
                for (Map.Entry<Object, Object> object : properties.entrySet()) {
                    String string;
                    if (n++ % 5 == 0) {
                        printStream.print("\n      ");
                    }
                    if ((string = (String)object.getKey()).toLowerCase().contains("password")) {
                        printStream.print(string + "=?; ");
                        continue;
                    }
                    printStream.print(string + "=" + object.getValue());
                }
                printStream.println();
            }
            if (databaseMetaData != null) {
                printStream.println(" - database: " + databaseMetaData.getDatabaseProductName() + " (" + databaseMetaData.getDatabaseProductVersion() + ")");
                printStream.print(" - driver: " + databaseMetaData.getDriverName() + " (" + databaseMetaData.getDriverVersion() + ")");
                printStream.print("jdbc-version=" + databaseMetaData.getJDBCMajorVersion() + "." + databaseMetaData.getJDBCMinorVersion() + "; ");
                printStream.print("max-connections=" + databaseMetaData.getMaxConnections() + "; ");
                printStream.print("sql-state-type=");
                switch (databaseMetaData.getSQLStateType()) {
                    case 2: {
                        printStream.print("SQL99; ");
                        break;
                    }
                    case 1: {
                        printStream.print("X-Open; ");
                        break;
                    }
                    default: {
                        printStream.print("unknown; ");
                    }
                }
                printStream.println();
            }
            if (this.printTypeMap) {
                Map<String, Class<?>> map = connection.getTypeMap();
                printStream.println(" - type map: ");
                if (map == null || map.isEmpty()) {
                    printStream.println("n/a");
                } else {
                    int n = 1;
                    for (Map.Entry<String, Class<?>> entry : map.entrySet()) {
                        if (n++ % 5 == 0) {
                            printStream.print("\n      ");
                        }
                        printStream.println(entry.getKey() + "->" + entry.getClass() + "; ");
                    }
                    printStream.println();
                }
            }
        }
        catch (SQLException sQLException) {
            printStream.println("   Cannot read property: " + sQLException.getLocalizedMessage());
        }
        finally {
            printStream.close();
        }
    }
}

