/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.watcher;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usefultoys.slf4j.LoggerConfig;
import org.usefultoys.slf4j.Session;
import org.usefultoys.slf4j.meter.Meter;
import org.usefultoys.slf4j.watcher.Markers;
import org.usefultoys.slf4j.watcher.WatcherConfig;
import org.usefultoys.slf4j.watcher.WatcherData;

public class Watcher
extends WatcherData
implements Runnable {
    private static final long serialVersionUID = 1L;
    private final transient Logger logger;
    private final transient Logger dataLogger;
    private final transient java.util.logging.Logger julLogger;
    private final transient java.util.logging.Logger julDataLogger;

    public Watcher(Logger logger) {
        this.logger = LoggerFactory.getLogger((String)(WatcherConfig.messagePrefix + logger.getName() + WatcherConfig.messageSuffix));
        this.dataLogger = LoggerFactory.getLogger((String)(WatcherConfig.dataPrefix + logger.getName() + WatcherConfig.dataSuffix));
        if (LoggerConfig.hackJulEnable) {
            this.julLogger = java.util.logging.Logger.getLogger(logger.getName());
            this.julDataLogger = java.util.logging.Logger.getLogger(this.dataLogger.getName());
        } else {
            this.julLogger = null;
            this.julDataLogger = null;
        }
        this.eventPosition = 0L;
        this.sessionUuid = WatcherConfig.dataUuidSize == 0 ? null : Session.uuid.substring(Session.uuid.length() - WatcherConfig.dataUuidSize);
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void run() {
        this.logCurrentStatus();
    }

    public void logCurrentStatus() {
        String string;
        this.time = System.nanoTime();
        ++this.eventPosition;
        if (this.logger.isInfoEnabled()) {
            this.collectRuntimeStatus();
            this.collectPlatformStatus();
            this.collectManagedBeanStatus();
            string = this.readableWrite();
            if (this.julLogger != null) {
                this.watcherMessageLogRecord(string);
                this.julLogger.info(string);
            } else {
                this.logger.info(Markers.MSG_WATCHER, string);
            }
        }
        if (this.logger.isTraceEnabled()) {
            string = this.write();
            if (this.julDataLogger != null) {
                this.julDataLogger.log(this.watcherDataLogRecord(string));
            } else {
                this.dataLogger.trace(Markers.DATA_WATCHER, string);
            }
        }
    }

    private void watcherMessageLogRecord(String string) {
        LogRecord logRecord = new LogRecord(Level.INFO, "[{0}] {1}");
        logRecord.setParameters(new Object[]{Markers.MSG_WATCHER.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("watcher");
        }
    }

    private LogRecord watcherDataLogRecord(String string) {
        LogRecord logRecord = new LogRecord(Level.FINEST, "[{0}] {1}");
        logRecord.setParameters(new Object[]{Markers.DATA_WATCHER.getName(), string});
        if (LoggerConfig.hackJulReplaceSource) {
            logRecord.setSourceClassName(Meter.class.getName());
            logRecord.setSourceMethodName("watcher");
        }
        return logRecord;
    }
}

