/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.internal;

import java.io.IOException;
import java.io.Serializable;
import org.usefultoys.slf4j.internal.EventReader;
import org.usefultoys.slf4j.internal.EventWriter;
import org.usefultoys.slf4j.internal.PatternDefinition;

public abstract class EventData
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String sessionUuid = null;
    protected long position = 0L;
    protected long time = 0L;
    public static final String SESSION_UUID = "s";
    public static final String EVENT_POSITION = "#";
    public static final String EVENT_TIME = "t";

    protected EventData() {
    }

    protected EventData(String string) {
        this.sessionUuid = string;
        this.position = 0L;
    }

    protected EventData(String string, long l) {
        this.sessionUuid = string;
        this.position = l;
    }

    protected final void nextPosition() {
        this.time = System.nanoTime();
        ++this.position;
    }

    public String getSessionUuid() {
        return this.sessionUuid;
    }

    public long getPosition() {
        return this.position;
    }

    public long getTime() {
        return this.time;
    }

    protected final void reset() {
        this.sessionUuid = null;
        this.position = 0L;
        this.time = 0L;
        this.resetImpl();
    }

    protected abstract void resetImpl();

    public final boolean isCompletelyEqualsTo(EventData eventData) {
        if (eventData == null) {
            throw new IllegalArgumentException("other == null");
        }
        if (this.position != eventData.position) {
            return false;
        }
        if (this.sessionUuid == null ? eventData.sessionUuid != null : !this.sessionUuid.equals(eventData.sessionUuid)) {
            return false;
        }
        if (this.time != eventData.time) {
            return false;
        }
        return this.isCompletelyEqualsImpl(eventData);
    }

    protected abstract boolean isCompletelyEqualsImpl(EventData var1);

    public abstract StringBuilder readableString(StringBuilder var1);

    public final StringBuilder write(StringBuilder stringBuilder, char c) {
        EventWriter eventWriter = new EventWriter(stringBuilder);
        eventWriter.open(c);
        this.writeKeyProperties(eventWriter);
        this.writePropertiesImpl(eventWriter);
        eventWriter.close();
        return stringBuilder;
    }

    private void writeKeyProperties(EventWriter eventWriter) {
        if (this.sessionUuid != null) {
            eventWriter.property(SESSION_UUID, this.sessionUuid);
        }
        if (this.position > 0L) {
            eventWriter.property(EVENT_POSITION, this.position);
        }
        if (this.time > 0L) {
            eventWriter.property(EVENT_TIME, this.time);
        }
    }

    protected abstract void writePropertiesImpl(EventWriter var1);

    protected final boolean read(String string, char c) {
        String string2 = PatternDefinition.extractPlausibleMessage(c, string);
        if (string2 == null) {
            return false;
        }
        this.reset();
        EventReader eventReader = new EventReader();
        eventReader.reset(string2);
        try {
            while (eventReader.hasMore()) {
                String string3 = eventReader.readPropertyName();
                if (this.readKeyProperties(eventReader, string3) || this.readPropertyImpl(eventReader, string3)) continue;
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean readKeyProperties(EventReader eventReader, String string) throws IOException {
        if (SESSION_UUID.equals(string)) {
            this.sessionUuid = eventReader.readString();
            return true;
        }
        if (EVENT_POSITION.equals(string)) {
            this.position = eventReader.readLong();
            return true;
        }
        if (EVENT_TIME.equals(string)) {
            this.time = eventReader.readLong();
            return true;
        }
        return false;
    }

    protected abstract boolean readPropertyImpl(EventReader var1, String var2) throws IOException;
}

