/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.internal;

import java.util.Map;
import org.usefultoys.slf4j.internal.PatternDefinition;

public final class EventWriter {
    private transient boolean firstProperty = true;
    private final transient StringBuilder builder;

    EventWriter(StringBuilder stringBuilder) {
        this.builder = stringBuilder;
    }

    void open(char c) {
        this.builder.append(c);
        this.builder.append('{');
    }

    void close() {
        this.builder.append('}');
    }

    public EventWriter property(String string, Enum<?> enum_) {
        this.property(string, enum_.name());
        return this;
    }

    public EventWriter property(String string, boolean bl) {
        this.property(string, Boolean.toString(bl));
        return this;
    }

    public EventWriter property(String string, long l) {
        this.property(string, Long.toString(l));
        return this;
    }

    public EventWriter property(String string, long l, long l2) {
        this.property(string, Long.toString(l), Long.toString(l2));
        return this;
    }

    public EventWriter property(String string, long l, long l2, long l3) {
        this.property(string, Long.toString(l), Long.toString(l2), Long.toString(l3));
        return this;
    }

    public EventWriter property(String string, long l, long l2, long l3, long l4) {
        this.property(string, Long.toString(l), Long.toString(l2), Long.toString(l3), Long.toString(l4));
        return this;
    }

    public EventWriter property(String string, double d) {
        this.property(string, Double.toString(d));
        return this;
    }

    public EventWriter property(String string, String string2) {
        if (!this.firstProperty) {
            this.builder.append(';');
        } else {
            this.firstProperty = false;
        }
        this.builder.append(string);
        this.builder.append('=');
        this.writePropertyValue(string2);
        return this;
    }

    public EventWriter property(String string, String string2, String string3) {
        if (!this.firstProperty) {
            this.builder.append(';');
        } else {
            this.firstProperty = false;
        }
        this.builder.append(string);
        this.builder.append('=');
        this.writePropertyValue(string2);
        this.builder.append('|');
        this.writePropertyValue(string3);
        return this;
    }

    public EventWriter property(String string, String string2, String string3, String string4) {
        if (!this.firstProperty) {
            this.builder.append(';');
        } else {
            this.firstProperty = false;
        }
        this.builder.append(string);
        this.builder.append('=');
        this.writePropertyValue(string2);
        this.builder.append('|');
        this.writePropertyValue(string3);
        this.builder.append('|');
        this.writePropertyValue(string4);
        return this;
    }

    public EventWriter property(String string, String string2, String string3, String string4, String string5) {
        if (!this.firstProperty) {
            this.builder.append(';');
        } else {
            this.firstProperty = false;
        }
        this.builder.append(string);
        this.builder.append('=');
        this.writePropertyValue(string2);
        this.builder.append('|');
        this.writePropertyValue(string3);
        this.builder.append('|');
        this.writePropertyValue(string4);
        this.builder.append('|');
        this.writePropertyValue(string5);
        return this;
    }

    public EventWriter property(String string, Map<String, String> map) {
        if (!this.firstProperty) {
            this.builder.append(';');
        } else {
            this.firstProperty = false;
        }
        this.builder.append(string);
        this.builder.append('=');
        this.builder.append('[');
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!bl) {
                this.builder.append(',');
            } else {
                bl = false;
            }
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            this.builder.append(string2);
            if (string3 == null) continue;
            this.builder.append(':');
            this.writeMapValue(string3);
        }
        this.builder.append(']');
        return this;
    }

    void writePropertyValue(String string) {
        this.builder.append(PatternDefinition.encodePropertyValuePattern.matcher(string).replaceAll("\\\\$1"));
    }

    void writeMapValue(String string) {
        this.builder.append(PatternDefinition.encodeMapValuePattern.matcher(string).replaceAll("\\\\$1"));
    }
}

