/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PatternDefinition {
    static final Pattern encodePropertyValuePattern = PatternDefinition.quotedCharsPattern('|', ';', '}', '\\', ']', ',');
    static final Pattern encodeMapValuePattern = PatternDefinition.quotedCharsPattern(']', ',', '}', '\\');
    static final String encodeReplacement = "\\\\$1";
    static final Pattern decodeValuePattern = Pattern.compile("184(.)");
    static final String decodeReplacement = "$1";
    static final Pattern messagePattern = Pattern.compile("(.)\\{([^\\}\\\\]*(?:\\\\.[^\"\\\\]*)*)\\}");

    private PatternDefinition() {
    }

    private static Pattern quotedCharsPattern(char ... cArray) {
        StringBuilder stringBuilder = new StringBuilder("([");
        for (char c : cArray) {
            stringBuilder.append('\\');
            stringBuilder.append(c);
        }
        stringBuilder.append("])");
        return Pattern.compile(stringBuilder.toString());
    }

    static String extractPlausibleMessage(char c, String string) {
        Matcher matcher = messagePattern.matcher(string);
        if (matcher.find() && matcher.group(1).charAt(0) == c) {
            return matcher.group(2);
        }
        return null;
    }
}

