/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.internal;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import org.usefultoys.slf4j.SystemConfig;
import org.usefultoys.slf4j.internal.EventData;
import org.usefultoys.slf4j.internal.EventReader;
import org.usefultoys.slf4j.internal.EventWriter;

public abstract class SystemData
extends EventData {
    private static final long serialVersionUID = 1L;
    protected long heap_commited = 0L;
    protected long heap_max = 0L;
    protected long heap_used = 0L;
    protected long nonHeap_commited = 0L;
    protected long nonHeap_max = 0L;
    protected long nonHeap_used = 0L;
    protected long objectPendingFinalizationCount = 0L;
    protected long classLoading_loaded = 0L;
    protected long classLoading_total = 0L;
    protected long classLoading_unloaded = 0L;
    protected long compilationTime = 0L;
    protected long garbageCollector_count = 0L;
    protected long garbageCollector_time = 0L;
    protected long runtime_usedMemory = 0L;
    protected long runtime_maxMemory = 0L;
    protected long runtime_totalMemory = 0L;
    protected double systemLoad = 0.0;
    public static final String PROP_MEMORY = "m";
    public static final String PROP_HEAP = "h";
    public static final String PROP_NON_HEAP = "nh";
    public static final String PROP_FINALIZATION_COUNT = "fc";
    public static final String PROP_CLASS_LOADING = "cl";
    public static final String PROP_COMPILATION_TIME = "ct";
    public static final String PROP_GARBAGE_COLLECTOR = "gc";
    public static final String PROP_SYSTEM_LOAD = "sl";

    protected SystemData() {
    }

    protected SystemData(String string) {
        super(string);
    }

    protected SystemData(String string, long l) {
        super(string, l);
    }

    @Override
    protected void resetImpl() {
        this.heap_commited = 0L;
        this.heap_max = 0L;
        this.heap_used = 0L;
        this.nonHeap_commited = 0L;
        this.nonHeap_max = 0L;
        this.nonHeap_used = 0L;
        this.objectPendingFinalizationCount = 0L;
        this.classLoading_loaded = 0L;
        this.classLoading_total = 0L;
        this.classLoading_unloaded = 0L;
        this.compilationTime = 0L;
        this.garbageCollector_count = 0L;
        this.garbageCollector_time = 0L;
        this.runtime_usedMemory = 0L;
        this.runtime_maxMemory = 0L;
        this.runtime_totalMemory = 0L;
        this.systemLoad = 0.0;
    }

    @Override
    protected boolean isCompletelyEqualsImpl(EventData eventData) {
        SystemData systemData = (SystemData)eventData;
        if (this.heap_commited != systemData.heap_commited) {
            return false;
        }
        if (this.heap_max != systemData.heap_max) {
            return false;
        }
        if (this.heap_used != systemData.heap_used) {
            return false;
        }
        if (this.nonHeap_commited != systemData.nonHeap_commited) {
            return false;
        }
        if (this.nonHeap_max != systemData.nonHeap_max) {
            return false;
        }
        if (this.nonHeap_used != systemData.nonHeap_used) {
            return false;
        }
        if (this.objectPendingFinalizationCount != systemData.objectPendingFinalizationCount) {
            return false;
        }
        if (this.classLoading_loaded != systemData.classLoading_loaded) {
            return false;
        }
        if (this.classLoading_total != systemData.classLoading_total) {
            return false;
        }
        if (this.classLoading_unloaded != systemData.classLoading_unloaded) {
            return false;
        }
        if (this.compilationTime != systemData.compilationTime) {
            return false;
        }
        if (this.garbageCollector_count != systemData.garbageCollector_count) {
            return false;
        }
        if (this.garbageCollector_time != systemData.garbageCollector_time) {
            return false;
        }
        if (this.runtime_usedMemory != systemData.runtime_usedMemory) {
            return false;
        }
        if (this.runtime_maxMemory != systemData.runtime_maxMemory) {
            return false;
        }
        if (this.runtime_totalMemory != systemData.runtime_totalMemory) {
            return false;
        }
        return Double.doubleToLongBits(this.systemLoad) == Double.doubleToLongBits(systemData.systemLoad);
    }

    protected void collectRuntimeStatus() {
        Runtime runtime = Runtime.getRuntime();
        this.runtime_totalMemory = runtime.totalMemory();
        this.runtime_usedMemory = this.runtime_totalMemory - runtime.freeMemory();
        this.runtime_maxMemory = runtime.maxMemory();
    }

    protected void collectPlatformStatus() {
        if (!SystemConfig.usePlatformManagedBean) {
            return;
        }
        if (SystemConfig.hasSunOperatingSystemMXBean) {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
            double d = operatingSystemMXBean.getSystemCpuLoad();
            if (d > 0.0) {
                this.systemLoad = d;
            }
        } else {
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            double d = operatingSystemMXBean.getSystemLoadAverage();
            if (d > 0.0) {
                this.systemLoad = d;
            }
        }
    }

    protected void collectManagedBeanStatus() {
        Object object;
        Object object2;
        Object object3;
        if (SystemConfig.useMemoryManagedBean) {
            object3 = ManagementFactory.getMemoryMXBean();
            object2 = object3.getHeapMemoryUsage();
            this.heap_commited = ((MemoryUsage)object2).getCommitted();
            this.heap_max = ((MemoryUsage)object2).getMax();
            this.heap_used = ((MemoryUsage)object2).getUsed();
            object = object3.getHeapMemoryUsage();
            this.nonHeap_commited = ((MemoryUsage)object).getCommitted();
            this.nonHeap_max = ((MemoryUsage)object).getMax();
            this.nonHeap_used = ((MemoryUsage)object).getUsed();
            this.objectPendingFinalizationCount = object3.getObjectPendingFinalizationCount();
        }
        if (SystemConfig.useClassLoadingManagedBean) {
            object3 = ManagementFactory.getClassLoadingMXBean();
            this.classLoading_loaded = object3.getLoadedClassCount();
            this.classLoading_total = object3.getTotalLoadedClassCount();
            this.classLoading_unloaded = object3.getUnloadedClassCount();
        }
        if (SystemConfig.useCompilationManagedBean) {
            object3 = ManagementFactory.getCompilationMXBean();
            this.compilationTime = object3.getTotalCompilationTime();
        }
        if (SystemConfig.useGarbageCollectionManagedBean) {
            object3 = ManagementFactory.getGarbageCollectorMXBeans();
            this.garbageCollector_count = 0L;
            this.garbageCollector_time = 0L;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (GarbageCollectorMXBean)object2.next();
                this.garbageCollector_count += object.getCollectionCount();
                this.garbageCollector_time += object.getCollectionTime();
            }
        }
    }

    @Override
    protected void writePropertiesImpl(EventWriter eventWriter) {
        if (this.runtime_usedMemory > 0L || this.runtime_totalMemory > 0L || this.runtime_maxMemory > 0L) {
            eventWriter.property(PROP_MEMORY, this.runtime_usedMemory, this.runtime_totalMemory, this.runtime_maxMemory);
        }
        if (this.heap_commited > 0L || this.heap_max > 0L || this.heap_used > 0L) {
            eventWriter.property(PROP_HEAP, this.heap_used, this.heap_commited, this.heap_max);
        }
        if (this.nonHeap_commited > 0L || this.nonHeap_max > 0L || this.nonHeap_used > 0L) {
            eventWriter.property(PROP_NON_HEAP, this.nonHeap_used, this.nonHeap_commited, this.nonHeap_max);
        }
        if (this.objectPendingFinalizationCount > 0L) {
            eventWriter.property(PROP_FINALIZATION_COUNT, this.objectPendingFinalizationCount);
        }
        if (this.classLoading_loaded > 0L || this.classLoading_total > 0L || this.classLoading_unloaded > 0L) {
            eventWriter.property(PROP_CLASS_LOADING, this.classLoading_total, this.classLoading_loaded, this.classLoading_unloaded);
        }
        if (this.compilationTime > 0L) {
            eventWriter.property(PROP_COMPILATION_TIME, this.compilationTime);
        }
        if (this.garbageCollector_count > 0L || this.garbageCollector_time > 0L) {
            eventWriter.property(PROP_GARBAGE_COLLECTOR, this.garbageCollector_count, this.garbageCollector_time);
        }
        if (this.systemLoad > 0.0) {
            eventWriter.property(PROP_SYSTEM_LOAD, this.systemLoad);
        }
    }

    @Override
    protected boolean readPropertyImpl(EventReader eventReader, String string) throws IOException {
        if (PROP_MEMORY.equals(string)) {
            this.runtime_usedMemory = eventReader.readLong();
            this.runtime_totalMemory = eventReader.readLong();
            this.runtime_maxMemory = eventReader.readLong();
            return true;
        }
        if (PROP_HEAP.equals(string)) {
            this.heap_used = eventReader.readLong();
            this.heap_commited = eventReader.readLong();
            this.heap_max = eventReader.readLong();
            return true;
        }
        if (PROP_NON_HEAP.equals(string)) {
            this.nonHeap_used = eventReader.readLong();
            this.nonHeap_commited = eventReader.readLong();
            this.nonHeap_max = eventReader.readLong();
            return true;
        }
        if (PROP_FINALIZATION_COUNT.equals(string)) {
            this.objectPendingFinalizationCount = eventReader.readLong();
            return true;
        }
        if (PROP_CLASS_LOADING.equals(string)) {
            this.classLoading_total = eventReader.readLong();
            this.classLoading_loaded = eventReader.readLong();
            this.classLoading_unloaded = eventReader.readLong();
            return true;
        }
        if (PROP_COMPILATION_TIME.equals(string)) {
            this.compilationTime = eventReader.readLong();
            return true;
        }
        if (PROP_GARBAGE_COLLECTOR.equals(string)) {
            this.garbageCollector_count = eventReader.readLong();
            this.garbageCollector_time = eventReader.readLong();
            return true;
        }
        if (PROP_SYSTEM_LOAD.equals(string)) {
            this.systemLoad = eventReader.readDouble();
            return true;
        }
        return false;
    }
}

