/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.color.ForegroundCompositeConverterBase;
import org.slf4j.Marker;
import org.usefultoys.slf4j.watcher.Markers;

public class StatusHighlightConverter
extends ForegroundCompositeConverterBase<ILoggingEvent> {
    public static final String ERROR_VISIBILITY = "91";
    public static final String WARN_VISIBILITY = "93";
    public static final String INFO_VISIBILITY = "92";
    public static final String DEBUG_VISIBILITY = "36";
    public static final String TRACE_VISIBILITY = "37";
    public static final String WATCHER_VISIBILITY = "34";
    public static final String DEFAULT_VISIBILITY = "39";
    public static final String LESS_VISIBILITY = "90";
    public static final String INCONSISTENCY_VISIBILITY = "31";
    public static final String REJECT_VISIBILITY = "95";
    public static final String SUCCESS_VISIBILITY = "92";
    public static final String START_VISIBILITY = "36";

    protected String getForegroundColorCode(ILoggingEvent iLoggingEvent) {
        Marker marker = iLoggingEvent.getMarker();
        if (marker == org.usefultoys.slf4j.meter.Markers.MSG_START) {
            return "36";
        }
        if (marker == org.usefultoys.slf4j.meter.Markers.MSG_PROGRESS) {
            return "36";
        }
        if (marker == org.usefultoys.slf4j.meter.Markers.MSG_OK) {
            return "92";
        }
        if (marker == org.usefultoys.slf4j.meter.Markers.MSG_SLOW_OK) {
            return WARN_VISIBILITY;
        }
        if (marker == org.usefultoys.slf4j.meter.Markers.MSG_REJECT) {
            return REJECT_VISIBILITY;
        }
        if (marker == org.usefultoys.slf4j.meter.Markers.MSG_FAIL) {
            return ERROR_VISIBILITY;
        }
        if (marker == org.usefultoys.slf4j.meter.Markers.DATA_START || marker == org.usefultoys.slf4j.meter.Markers.DATA_PROGRESS || marker == org.usefultoys.slf4j.meter.Markers.DATA_OK || marker == org.usefultoys.slf4j.meter.Markers.DATA_SLOW_OK || marker == org.usefultoys.slf4j.meter.Markers.DATA_REJECT || marker == org.usefultoys.slf4j.meter.Markers.DATA_FAIL || marker == Markers.DATA_WATCHER) {
            return LESS_VISIBILITY;
        }
        if (marker == org.usefultoys.slf4j.meter.Markers.BUG || marker == org.usefultoys.slf4j.meter.Markers.ILLEGAL || marker == org.usefultoys.slf4j.meter.Markers.INCONSISTENT_START || marker == org.usefultoys.slf4j.meter.Markers.INCONSISTENT_INCREMENT || marker == org.usefultoys.slf4j.meter.Markers.INCONSISTENT_PROGRESS || marker == org.usefultoys.slf4j.meter.Markers.INCONSISTENT_EXCEPTION || marker == org.usefultoys.slf4j.meter.Markers.INCONSISTENT_REJECT || marker == org.usefultoys.slf4j.meter.Markers.INCONSISTENT_OK || marker == org.usefultoys.slf4j.meter.Markers.INCONSISTENT_FAIL || marker == org.usefultoys.slf4j.meter.Markers.INCONSISTENT_FINALIZED) {
            return INCONSISTENCY_VISIBILITY;
        }
        if (marker == Markers.MSG_WATCHER) {
            return WATCHER_VISIBILITY;
        }
        Level level = iLoggingEvent.getLevel();
        switch (level.toInt()) {
            case 40000: {
                return ERROR_VISIBILITY;
            }
            case 30000: {
                return WARN_VISIBILITY;
            }
            case 20000: {
                return "92";
            }
            case 10000: {
                return "36";
            }
            case 5000: {
                return TRACE_VISIBILITY;
            }
        }
        return DEFAULT_VISIBILITY;
    }
}

