/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.meter;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.usefultoys.slf4j.LoggerFactory;
import org.usefultoys.slf4j.Session;
import org.usefultoys.slf4j.meter.Markers;
import org.usefultoys.slf4j.meter.MeterConfig;
import org.usefultoys.slf4j.meter.MeterData;
import sun.misc.Unsafe;

public class Meter
extends MeterData
implements Closeable {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION = "Meter cannot create exception of type {}.";
    private static final String ERROR_MSG_METER_ALREADY_STARTED = "Meter already started. id={}";
    private static final String ERROR_MSG_METER_ALREADY_STOPPED = "Meter already stopped. id={}";
    private static final String ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED = "Meter stopped but not started. id={}";
    private static final String ERROR_MSG_METER_STARTED_AND_NEVER_STOPPED = "Meter started and never stopped. id={}";
    private static final String ERROR_MSG_METER_INCREMENTED_BUT_NOT_STARTED = "Meter incremented but not started. id={}";
    private static final String ERROR_MSG_METER_PROGRESS_BUT_NOT_STARTED = "Meter progress but not started. id={}";
    private static final String ERROR_MSG_METHOD_THREW_EXCEPTION = "Meter.{}(...) method threw exception. id={}";
    private static final String ERROR_MSG_ILLEGAL_ARGUMENT = "Illegal call to Meter.{}: {}. id={}";
    private static final String ERROR_MSG_METER_OUT_OF_ORDER = "Meter out of order. id={}";
    private static final String ERROR_MSG_NULL_ARGUMENT = "Null argument. id={}";
    private static final String ERROR_MSG_NON_POSITIVE_ARGUMENT = "Non positive argument";
    private static final String ERROR_MSG_ILLEGAL_STRING_FORMAT = "Illegal string format";
    private static final String ERROR_MSG_NON_FORWARD_ITERATION = "Non forward iteration";
    private static final String MY_CLASS_NAME = Meter.class.getName();
    private static final String NULL_VALUE = "<null>";
    private static final String UNKNOWN_LOGGER_NAME = "???";
    private static final String FAIL_PATH_TRY_WITH_RESOURCES = "try-with-resources";
    public static final String CONTEXT_RESULT = "result";
    private final transient Logger messageLogger;
    private final transient Logger dataLogger;
    static final ConcurrentMap<String, AtomicLong> EVENT_COUNTER = new ConcurrentHashMap<String, AtomicLong>();
    private transient long lastProgressTime = 0L;
    private transient long lastProgressIteration = 0L;
    private static final ThreadLocal<WeakReference<Meter>> localThreadInstance = new ThreadLocal();
    private WeakReference<Meter> previousInstance;
    private static Unsafe unsafe;

    public Meter(Logger logger) {
        this(logger, null);
    }

    public Meter(Logger logger, String string) {
        this(logger, string, null);
    }

    public Meter(Logger logger, String string, String string2) {
        super(Session.uuid, Meter.extractNextPosition(logger.getName(), string), logger.getName(), string, string2);
        this.messageLogger = org.slf4j.LoggerFactory.getLogger((String)(MeterConfig.messagePrefix + logger.getName() + MeterConfig.messageSuffix));
        this.dataLogger = org.slf4j.LoggerFactory.getLogger((String)(MeterConfig.dataPrefix + logger.getName() + MeterConfig.dataSuffix));
    }

    private static long extractNextPosition(String string, String string2) {
        String string3 = string2 == null ? string : string + "/" + string2;
        EVENT_COUNTER.putIfAbsent(string3, new AtomicLong(0L));
        AtomicLong atomicLong = (AtomicLong)EVENT_COUNTER.get(string3);
        atomicLong.compareAndSet(Long.MAX_VALUE, 0L);
        return atomicLong.incrementAndGet();
    }

    public static Meter getCurrentInstance() {
        Meter meter;
        WeakReference<Meter> weakReference = localThreadInstance.get();
        Meter meter2 = meter = weakReference == null ? null : (Meter)weakReference.get();
        if (meter == null) {
            return new Meter(LoggerFactory.getLogger(UNKNOWN_LOGGER_NAME));
        }
        return meter;
    }

    public Meter sub(String string) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"sub(name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
        }
        Meter meter = new Meter(this.messageLogger, this.operation == null ? string : this.operation + '/' + string, this.getFullID());
        if (this.context != null) {
            meter.context = new HashMap(this.context);
        }
        return meter;
    }

    public Meter m(String string) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"m(message)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
        }
        this.description = string;
        return this;
    }

    public Meter m(String string, Object ... objectArray) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"m(message, args...)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            this.description = null;
            return this;
        }
        try {
            this.description = String.format(string, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"m(format, args...)", ERROR_MSG_ILLEGAL_STRING_FORMAT, this.getFullID(), new IllegalMeterUsage(2, (Throwable)illegalFormatException)});
        }
        return this;
    }

    public Meter limitMilliseconds(long l) {
        if (l <= 0L) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"limitMilliseconds(timeLimit)", ERROR_MSG_NON_POSITIVE_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        this.timeLimit = l * 1000L * 1000L;
        return this;
    }

    public Meter iterations(long l) {
        if (l <= 0L) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"iterations(expectedIterations)", ERROR_MSG_NON_POSITIVE_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        this.expectedIterations = l;
        return this;
    }

    public Meter ctx(String string) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, null);
        return this;
    }

    public Meter ctx(boolean bl, String string) {
        if (!bl) {
            return this;
        }
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(condition,name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, null);
        return this;
    }

    public Meter ctx(boolean bl, String string, String string2) {
        if (bl) {
            if (string == null) {
                this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(condition,name,name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
                return this;
            }
            if (this.context == null) {
                this.context = new LinkedHashMap();
            }
            this.context.put(string, null);
        } else {
            if (string2 == null) {
                this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(condition,name,name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
                return this;
            }
            if (this.context == null) {
                this.context = new LinkedHashMap();
            }
            this.context.put(string2, null);
        }
        return this;
    }

    public Meter ctx(String string, int n) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, Integer.toString(n));
        return this;
    }

    public Meter ctx(String string, long l) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, Long.toString(l));
        return this;
    }

    public Meter ctx(String string, boolean bl) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, Boolean.toString(bl));
        return this;
    }

    public Meter ctx(String string, float f) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, Float.toString(f));
        return this;
    }

    public Meter ctx(String string, double d) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, Double.toString(d));
        return this;
    }

    public Meter ctx(String string, Integer n) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, n == null ? NULL_VALUE : n.toString());
        return this;
    }

    public Meter ctx(String string, Long l) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, l == null ? NULL_VALUE : l.toString());
        return this;
    }

    public Meter ctx(String string, Boolean bl) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, bl == null ? NULL_VALUE : bl.toString());
        return this;
    }

    public Meter ctx(String string, Float f) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, f == null ? NULL_VALUE : f.toString());
        return this;
    }

    public Meter ctx(String string, Double d) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, d == null ? NULL_VALUE : d.toString());
        return this;
    }

    public Meter ctx(String string, Object object) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, object == null ? NULL_VALUE : object.toString());
        return this;
    }

    public Meter ctx(String string, String string2) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, value)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        this.context.put(string, string2 == null ? NULL_VALUE : string2);
        return this;
    }

    public Meter ctx(String string, String string2, Object ... objectArray) {
        if (string == null || string2 == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, format, args...)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            this.context = new LinkedHashMap();
        }
        try {
            this.ctx(string, String.format(string2, objectArray));
        }
        catch (IllegalFormatException illegalFormatException) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"ctx(name, format, args...)", ERROR_MSG_ILLEGAL_STRING_FORMAT, this.getFullID(), new IllegalMeterUsage(2, (Throwable)illegalFormatException)});
        }
        return this;
    }

    public Meter unctx(String string) {
        if (string == null) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"unctx(name)", ERROR_MSG_NULL_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (this.context == null) {
            return this;
        }
        this.context.remove(string);
        return this;
    }

    public Meter start() {
        try {
            if (this.startTime != 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_START, ERROR_MSG_METER_ALREADY_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else {
                this.previousInstance = localThreadInstance.get();
                localThreadInstance.set(new WeakReference<Meter>(this));
            }
            this.lastProgressTime = this.startTime = System.nanoTime();
            if (this.messageLogger.isDebugEnabled()) {
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                this.messageLogger.debug(Markers.MSG_START, this.readableWrite());
                if (this.dataLogger.isTraceEnabled()) {
                    this.dataLogger.trace(Markers.DATA_START, this.write());
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.messageLogger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"start", this.getFullID(), exception});
        }
        return this;
    }

    public Meter inc() {
        if (this.startTime == 0L) {
            this.messageLogger.error(Markers.INCONSISTENT_INCREMENT, ERROR_MSG_METER_INCREMENTED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(4));
        }
        ++this.currentIteration;
        return this;
    }

    public Meter incBy(long l) {
        if (this.startTime == 0L) {
            this.messageLogger.error(Markers.INCONSISTENT_INCREMENT, ERROR_MSG_METER_INCREMENTED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(4));
        }
        if (l <= 0L) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"incBy(increment)", ERROR_MSG_NON_POSITIVE_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        this.currentIteration += l;
        return this;
    }

    public Meter incTo(long l) {
        if (this.startTime == 0L) {
            this.messageLogger.error(Markers.INCONSISTENT_INCREMENT, ERROR_MSG_METER_INCREMENTED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(4));
        }
        if (l <= 0L) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"incTo(currentIteration)", ERROR_MSG_NON_POSITIVE_ARGUMENT, this.getFullID(), new IllegalMeterUsage(2)});
            return this;
        }
        if (l <= this.currentIteration) {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_ILLEGAL_ARGUMENT, new Object[]{"incTo(currentIteration)", ERROR_MSG_NON_FORWARD_ITERATION, this.getFullID(), new IllegalMeterUsage(2)});
        }
        this.currentIteration = l;
        return this;
    }

    public Meter progress() {
        try {
            long l;
            if (this.startTime == 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_PROGRESS, ERROR_MSG_METER_PROGRESS_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            long l2 = MeterConfig.progressPeriodMilliseconds * 1000L * 1000L;
            if (this.currentIteration > this.lastProgressIteration && (l = System.nanoTime()) - this.lastProgressTime > l2) {
                this.lastProgressIteration = this.currentIteration;
                this.lastProgressTime = l;
                if (this.messageLogger.isInfoEnabled()) {
                    this.collectRuntimeStatus();
                    this.collectPlatformStatus();
                    this.messageLogger.info(Markers.MSG_PROGRESS, this.readableWrite());
                    if (this.dataLogger.isTraceEnabled()) {
                        String string = this.write();
                        if (this.startTime != 0L && this.timeLimit != 0L && l - this.startTime > this.timeLimit) {
                            this.dataLogger.trace(Markers.DATA_SLOW_PROGRESS, string);
                        } else if (this.dataLogger.isTraceEnabled()) {
                            this.dataLogger.trace(Markers.DATA_PROGRESS, string);
                        }
                    }
                    if (this.context != null) {
                        this.context.clear();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.messageLogger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"progress", this.getFullID(), exception});
        }
        return this;
    }

    public Meter path(Object object) {
        if (object instanceof String) {
            this.okPath = (String)object;
        } else if (object instanceof Enum) {
            this.okPath = ((Enum)object).name();
        } else if (object instanceof Throwable) {
            this.okPath = object.getClass().getSimpleName();
        } else if (object != null) {
            this.okPath = object.toString();
        } else {
            this.messageLogger.error(Markers.ILLEGAL, ERROR_MSG_NULL_ARGUMENT, (Object)this.getFullID(), (Object)new IllegalMeterUsage(4));
        }
        return this;
    }

    public Meter ok() {
        try {
            long l = System.nanoTime();
            if (this.stopTime != 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_ALREADY_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.startTime == 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.checkCurrentInstance()) {
                this.messageLogger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_OUT_OF_ORDER, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            this.stopTime = l;
            this.failPath = null;
            this.failMessage = null;
            this.rejectPath = null;
            localThreadInstance.set(this.previousInstance);
            if (this.messageLogger.isWarnEnabled()) {
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                boolean bl = this.startTime != 0L && this.timeLimit != 0L && this.stopTime - this.startTime > this.timeLimit;
                String string = this.readableWrite();
                if (bl) {
                    this.messageLogger.warn(Markers.MSG_SLOW_OK, string);
                } else if (this.messageLogger.isInfoEnabled()) {
                    this.messageLogger.info(Markers.MSG_OK, string);
                }
                if (this.dataLogger.isTraceEnabled()) {
                    String string2 = this.write();
                    if (bl) {
                        this.dataLogger.trace(Markers.DATA_SLOW_OK, string2);
                    } else {
                        this.dataLogger.trace(Markers.DATA_OK, string2);
                    }
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.messageLogger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"ok", this.getFullID(), exception});
        }
        return this;
    }

    private boolean checkCurrentInstance() {
        WeakReference<Meter> weakReference = localThreadInstance.get();
        return weakReference == null || weakReference.get() != this;
    }

    public Meter ok(Object object) {
        try {
            long l = System.nanoTime();
            if (this.stopTime != 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_ALREADY_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.startTime == 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.checkCurrentInstance()) {
                this.messageLogger.error(Markers.INCONSISTENT_OK, ERROR_MSG_METER_OUT_OF_ORDER, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            this.stopTime = l;
            this.failPath = null;
            this.failMessage = null;
            this.rejectPath = null;
            localThreadInstance.set(this.previousInstance);
            if (object instanceof String) {
                this.okPath = (String)object;
            } else if (object instanceof Enum) {
                this.okPath = ((Enum)object).name();
            } else if (object instanceof Throwable) {
                this.okPath = object.getClass().getSimpleName();
            } else if (object != null) {
                this.okPath = object.toString();
            } else {
                this.messageLogger.error(Markers.INCONSISTENT_OK, ERROR_MSG_NULL_ARGUMENT, (Object)this.getFullID(), (Object)new IllegalMeterUsage(4));
            }
            if (this.messageLogger.isWarnEnabled()) {
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                boolean bl = this.startTime != 0L && this.timeLimit != 0L && this.stopTime - this.startTime > this.timeLimit;
                String string = this.readableWrite();
                if (bl) {
                    this.messageLogger.warn(Markers.MSG_SLOW_OK, string);
                } else if (this.messageLogger.isInfoEnabled()) {
                    this.messageLogger.info(Markers.MSG_OK, string);
                }
                if (this.dataLogger.isTraceEnabled()) {
                    String string2 = this.write();
                    if (bl) {
                        this.dataLogger.trace(Markers.DATA_SLOW_OK, string2);
                    } else {
                        this.dataLogger.trace(Markers.DATA_OK, string2);
                    }
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.messageLogger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"ok", this.getFullID(), exception});
        }
        return this;
    }

    public Meter reject(Object object) {
        try {
            long l = System.nanoTime();
            if (this.stopTime != 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_REJECT, ERROR_MSG_METER_ALREADY_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.startTime == 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_REJECT, ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.checkCurrentInstance()) {
                this.messageLogger.error(Markers.INCONSISTENT_REJECT, ERROR_MSG_METER_OUT_OF_ORDER, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            this.stopTime = l;
            this.failPath = null;
            this.failMessage = null;
            this.okPath = null;
            localThreadInstance.set(this.previousInstance);
            if (object instanceof String) {
                this.rejectPath = (String)object;
            } else if (object instanceof Enum) {
                this.rejectPath = ((Enum)object).name();
            } else if (object instanceof Throwable) {
                this.rejectPath = object.getClass().getSimpleName();
            } else if (object != null) {
                this.rejectPath = object.toString();
            } else {
                this.messageLogger.error(Markers.INCONSISTENT_REJECT, ERROR_MSG_NULL_ARGUMENT, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            if (this.messageLogger.isInfoEnabled()) {
                String string;
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                if (this.messageLogger.isInfoEnabled()) {
                    string = this.readableWrite();
                    this.messageLogger.info(Markers.MSG_REJECT, string);
                }
                if (this.dataLogger.isTraceEnabled()) {
                    string = this.write();
                    this.dataLogger.trace(Markers.DATA_REJECT, string);
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.messageLogger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"reject", this.getFullID(), exception});
        }
        return this;
    }

    public Meter fail(Object object) {
        try {
            long l = System.nanoTime();
            if (this.stopTime != 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_FAIL, ERROR_MSG_METER_ALREADY_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.startTime == 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_FAIL, ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.checkCurrentInstance()) {
                this.messageLogger.error(Markers.INCONSISTENT_FAIL, ERROR_MSG_METER_OUT_OF_ORDER, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            this.stopTime = l;
            this.rejectPath = null;
            this.okPath = null;
            localThreadInstance.set(this.previousInstance);
            if (object instanceof String) {
                this.failPath = (String)object;
            } else if (object instanceof Enum) {
                this.failPath = ((Enum)object).name();
            } else if (object instanceof Throwable) {
                this.failPath = object.getClass().getName();
                this.failMessage = ((Throwable)object).getLocalizedMessage();
            } else if (object != null) {
                this.failPath = object.toString();
            } else {
                this.messageLogger.error(Markers.INCONSISTENT_FAIL, ERROR_MSG_NULL_ARGUMENT, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            if (this.messageLogger.isErrorEnabled()) {
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                this.messageLogger.error(Markers.MSG_FAIL, this.readableWrite());
                if (this.dataLogger.isTraceEnabled()) {
                    this.dataLogger.trace(Markers.DATA_FAIL, this.write());
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.messageLogger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"fail", this.getFullID(), exception});
        }
        return this;
    }

    protected void finalize() throws Throwable {
        if (this.stopTime == 0L && !this.category.equals(UNKNOWN_LOGGER_NAME)) {
            this.messageLogger.error(Markers.INCONSISTENT_FINALIZED, ERROR_MSG_METER_STARTED_AND_NEVER_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(1));
        }
        super.finalize();
    }

    @Override
    public void close() {
        try {
            if (this.stopTime != 0L) {
                return;
            }
            long l = System.nanoTime();
            if (this.stopTime != 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_CLOSE, ERROR_MSG_METER_ALREADY_STOPPED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.startTime == 0L) {
                this.messageLogger.error(Markers.INCONSISTENT_CLOSE, ERROR_MSG_METER_STOPPED_BUT_NOT_STARTED, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            } else if (this.checkCurrentInstance()) {
                this.messageLogger.error(Markers.INCONSISTENT_CLOSE, ERROR_MSG_METER_OUT_OF_ORDER, (Object)this.getFullID(), (Object)new IllegalMeterUsage(2));
            }
            this.stopTime = l;
            this.rejectPath = null;
            this.okPath = null;
            localThreadInstance.set(this.previousInstance);
            this.failPath = FAIL_PATH_TRY_WITH_RESOURCES;
            if (this.messageLogger.isErrorEnabled()) {
                this.collectRuntimeStatus();
                this.collectPlatformStatus();
                this.messageLogger.error(Markers.MSG_FAIL, this.readableWrite(), (Object)this.failPath);
                if (this.dataLogger.isTraceEnabled()) {
                    this.dataLogger.trace(Markers.DATA_FAIL, this.write());
                }
                if (this.context != null) {
                    this.context.clear();
                }
            }
        }
        catch (Exception exception) {
            this.messageLogger.error(Markers.BUG, ERROR_MSG_METHOD_THREW_EXCEPTION, new Object[]{"close", this.getFullID(), exception});
        }
    }

    public void run(Runnable runnable) {
        if (this.startTime == 0L) {
            this.start();
        }
        try {
            runnable.run();
            if (this.stopTime == 0L) {
                this.ok();
            }
        }
        catch (RuntimeException runtimeException) {
            this.fail(runtimeException);
            throw runtimeException;
        }
    }

    public void runOrReject(Runnable runnable, Class<? extends Exception> ... classArray) {
        if (this.startTime == 0L) {
            this.start();
        }
        try {
            runnable.run();
            if (this.stopTime == 0L) {
                this.ok();
            }
        }
        catch (Exception exception) {
            for (Class<? extends Exception> clazz : classArray) {
                if (!clazz.isAssignableFrom(exception.getClass())) continue;
                this.reject(exception);
                unsafe.throwException(exception);
            }
            this.fail(exception);
            unsafe.throwException(exception);
        }
    }

    public <T> T call(Callable<T> callable) throws Exception {
        if (this.startTime == 0L) {
            this.start();
        }
        try {
            T t = callable.call();
            this.ctx(CONTEXT_RESULT, t);
            if (this.stopTime == 0L) {
                this.ok();
            }
            return t;
        }
        catch (Exception exception) {
            this.fail(exception);
            throw exception;
        }
    }

    public <T> T callOrRejectChecked(Callable<T> callable) {
        if (this.startTime == 0L) {
            this.start();
        }
        try {
            T t = callable.call();
            this.ctx(CONTEXT_RESULT, t);
            if (this.stopTime == 0L) {
                this.ok();
            }
            return t;
        }
        catch (RuntimeException runtimeException) {
            this.fail(runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            this.reject(exception);
            unsafe.throwException(exception);
            return null;
        }
    }

    public <T> T callOrReject(Callable<T> callable, Class<? extends Exception> ... classArray) {
        if (this.startTime == 0L) {
            this.start();
        }
        try {
            T t = callable.call();
            this.ctx(CONTEXT_RESULT, t);
            if (this.stopTime == 0L) {
                this.ok();
            }
            return t;
        }
        catch (Exception exception) {
            for (Class<? extends Exception> clazz : classArray) {
                if (!clazz.isAssignableFrom(exception.getClass())) continue;
                this.reject(exception);
                unsafe.throwException(exception);
            }
            this.fail(exception);
            unsafe.throwException(exception);
            return null;
        }
    }

    public <T> T safeCall(Callable<T> callable) {
        if (this.startTime == 0L) {
            this.start();
        }
        try {
            T t = callable.call();
            this.ctx(CONTEXT_RESULT, t);
            if (this.stopTime == 0L) {
                this.ok();
            }
            return t;
        }
        catch (RuntimeException runtimeException) {
            this.fail(runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            this.fail(exception);
            throw new RuntimeException("Meter.safeCall wrapped exception.", exception);
        }
    }

    public <E extends RuntimeException, T> T safeCall(Class<E> clazz, Callable<T> callable) {
        if (this.stopTime == 0L) {
            this.start();
        }
        try {
            T t = callable.call();
            this.ctx(CONTEXT_RESULT, t);
            if (this.stopTime == 0L) {
                this.ok();
            }
            return t;
        }
        catch (RuntimeException runtimeException) {
            this.fail(runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            this.fail(exception);
            throw this.convertException(clazz, exception);
        }
    }

    private <T extends RuntimeException> RuntimeException convertException(Class<T> clazz, Exception exception) {
        String string = "Failed: " + (this.description != null ? this.description : this.category);
        try {
            return (RuntimeException)clazz.getConstructor(String.class, Throwable.class).newInstance(string, exception);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.messageLogger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        catch (SecurityException securityException) {
            this.messageLogger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        catch (InstantiationException instantiationException) {
            this.messageLogger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.messageLogger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.messageLogger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.messageLogger.error(Markers.INCONSISTENT_EXCEPTION, ERROR_MSG_METER_CANNOT_CREATE_EXCEPTION, clazz, (Object)exception);
        }
        return new RuntimeException(exception);
    }

    static {
        Field field = null;
        try {
            field = Unsafe.class.getDeclaredField("theUnsafe");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        field.setAccessible(true);
        try {
            unsafe = (Unsafe)field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public static class IllegalMeterUsage
    extends MeterThrowable {
        private static final long serialVersionUID = 1L;

        IllegalMeterUsage(int n) {
            super(n);
        }

        IllegalMeterUsage(int n, Throwable throwable) {
            super(n, throwable);
        }
    }

    public static class MeterThrowable
    extends Throwable {
        private static final long serialVersionUID = 1L;

        MeterThrowable(int n) {
            this(n + 1, null);
        }

        MeterThrowable(int n, Throwable throwable) {
            super(throwable);
            ++n;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            while (MY_CLASS_NAME.equals(stackTraceElementArray[n].getClassName())) {
                ++n;
            }
            stackTraceElementArray = Arrays.copyOfRange(stackTraceElementArray, n, stackTraceElementArray.length);
            this.setStackTrace(stackTraceElementArray);
        }

        MeterThrowable() {
            super("Illegal Meter usage.");
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

