/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.meter;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.usefultoys.slf4j.SessionConfig;
import org.usefultoys.slf4j.internal.EventData;
import org.usefultoys.slf4j.internal.EventReader;
import org.usefultoys.slf4j.internal.EventWriter;
import org.usefultoys.slf4j.internal.SystemData;
import org.usefultoys.slf4j.meter.MeterConfig;
import org.usefultoys.slf4j.utils.UnitFormatter;

public class MeterData
extends SystemData {
    private static final long serialVersionUID = 2L;
    public static final char DETAILED_MESSAGE_PREFIX = 'M';
    protected String category = null;
    protected String operation = null;
    protected String parent = null;
    protected String description = null;
    protected long createTime = 0L;
    protected long startTime = 0L;
    protected long stopTime = 0L;
    protected long timeLimit = 0L;
    protected long currentIteration = 0L;
    protected long expectedIterations = 0L;
    protected String okPath = null;
    protected String rejectPath = null;
    protected String failPath = null;
    protected String failMessage = null;
    protected Map<String, String> context = null;
    public static final String PROP_DESCRIPTION = "d";
    public static final String PROP_PATH_ID = "p";
    public static final String PROP_REJECT_ID = "r";
    public static final String PROP_FAIL_ID = "f";
    public static final String PROP_CREATE_TIME = "t0";
    public static final String PROP_START_TIME = "t1";
    public static final String PROP_STOP_TIME = "t2";
    public static final String PROP_ITERATION = "i";
    public static final String PROP_EXPECTED_ITERATION = "ei";
    public static final String PROP_LIMIT_TIME = "tl";
    public static final String PROP_CONTEXT = "ctx";
    public static final String EVENT_CATEGORY = "c";
    public static final String EVENT_NAME = "n";
    public static final String EVENT_PARENT = "ep";

    public MeterData() {
    }

    protected MeterData(String string, long l, String string2, String string3, String string4) {
        super(string, l);
        this.category = string2;
        this.operation = string3;
        this.parent = string4;
        this.createTime = System.nanoTime();
    }

    public String getFullID() {
        if (this.operation == null) {
            return this.category + '/' + this.position;
        }
        return this.category + '/' + this.operation + '#' + this.position;
    }

    public String getCategory() {
        return this.category;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getParent() {
        return this.parent;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOkPath() {
        return this.okPath;
    }

    public String getRejectPath() {
        return this.rejectPath;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public long getCurrentIteration() {
        return this.currentIteration;
    }

    public long getExpectedIterations() {
        return this.expectedIterations;
    }

    public String getFailPath() {
        return this.failPath;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public boolean isStarted() {
        return this.startTime != 0L;
    }

    public boolean isStopped() {
        return this.stopTime != 0L;
    }

    public boolean isOK() {
        return this.stopTime != 0L && this.failPath == null && this.rejectPath == null;
    }

    public boolean isReject() {
        return this.stopTime != 0L && this.rejectPath != null;
    }

    public boolean isFail() {
        return this.stopTime != 0L && this.failPath != null;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public Map<String, String> getContext() {
        if (this.context == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.context);
    }

    public boolean isSlow() {
        return this.timeLimit != 0L && this.stopTime != 0L && this.startTime != 0L && this.stopTime - this.startTime > this.timeLimit;
    }

    public String getPath() {
        if (this.failPath != null) {
            return this.failPath;
        }
        if (this.rejectPath != null) {
            return this.rejectPath;
        }
        return this.okPath;
    }

    public long getExecutionTime() {
        if (this.startTime == 0L) {
            return 0L;
        }
        if (this.stopTime == 0L) {
            return System.nanoTime() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    public long getWaitingTime() {
        if (this.startTime == 0L) {
            return System.nanoTime() - this.createTime;
        }
        return this.startTime - this.createTime;
    }

    public double getIterationsPerSecond() {
        if (this.currentIteration == 0L || this.startTime == 0L) {
            return 0.0;
        }
        float f = this.getExecutionTime();
        if (f == 0.0f) {
            return 0.0;
        }
        return (double)this.currentIteration / (double)f * 1.0E9;
    }

    @Override
    protected void resetImpl() {
        super.resetImpl();
        this.category = null;
        this.operation = null;
        this.parent = null;
        this.description = null;
        this.okPath = null;
        this.rejectPath = null;
        this.createTime = 0L;
        this.startTime = 0L;
        this.stopTime = 0L;
        this.currentIteration = 0L;
        this.expectedIterations = 0L;
        this.failPath = null;
        this.failMessage = null;
        this.timeLimit = 0L;
        this.context = null;
    }

    @Override
    protected boolean isCompletelyEqualsImpl(EventData eventData) {
        MeterData meterData = (MeterData)eventData;
        if (this.description == null ? meterData.description != null : !this.description.equals(meterData.description)) {
            return false;
        }
        if (this.category == null ? meterData.category != null : !this.category.equals(meterData.category)) {
            return false;
        }
        if (this.operation == null ? meterData.operation != null : !this.operation.equals(meterData.operation)) {
            return false;
        }
        if (this.parent == null ? meterData.parent != null : !this.parent.equals(meterData.parent)) {
            return false;
        }
        if (this.okPath == null ? meterData.okPath != null : !this.okPath.equals(meterData.okPath)) {
            return false;
        }
        if (this.rejectPath == null ? meterData.rejectPath != null : !this.rejectPath.equals(meterData.rejectPath)) {
            return false;
        }
        if (this.createTime != meterData.createTime) {
            return false;
        }
        if (this.startTime != meterData.startTime) {
            return false;
        }
        if (this.stopTime != meterData.stopTime) {
            return false;
        }
        if (this.currentIteration != meterData.currentIteration) {
            return false;
        }
        if (this.expectedIterations != meterData.expectedIterations) {
            return false;
        }
        if (this.failPath == null ? meterData.failPath != null : !this.failPath.equals(meterData.failPath)) {
            return false;
        }
        if (this.failMessage == null ? meterData.failMessage != null : !this.failMessage.equals(meterData.failMessage)) {
            return false;
        }
        if (this.timeLimit != meterData.timeLimit) {
            return false;
        }
        if (!(this.context == meterData.context || this.context != null && this.context.equals(meterData.context))) {
            return false;
        }
        return super.isCompletelyEqualsImpl(eventData);
    }

    @Override
    protected void collectRuntimeStatus() {
        super.collectRuntimeStatus();
    }

    @Override
    public StringBuilder readableString(StringBuilder stringBuilder) {
        if (MeterConfig.printStatus) {
            if (this.stopTime != 0L) {
                if (this.failPath == null && this.rejectPath == null) {
                    if (this.timeLimit != 0L && this.startTime != 0L && this.stopTime - this.startTime > this.timeLimit) {
                        stringBuilder.append("OK (Slow)");
                    } else {
                        stringBuilder.append("OK");
                    }
                } else if (this.rejectPath != null) {
                    stringBuilder.append("REJECT");
                } else if (this.failPath != null) {
                    stringBuilder.append("FAIL");
                }
            } else if (this.startTime != 0L && this.currentIteration == 0L) {
                stringBuilder.append("STARTED");
            } else if (this.startTime != 0L) {
                stringBuilder.append("PROGRESS");
            } else {
                stringBuilder.append("SCHEDULED");
            }
            stringBuilder.append(": ");
        }
        if (MeterConfig.printCategory) {
            int n = this.category.lastIndexOf(46) + 1;
            stringBuilder.append(this.category.substring(n));
        }
        if (this.operation != null) {
            if (MeterConfig.printCategory) {
                stringBuilder.append('/');
            }
            stringBuilder.append(this.operation);
        }
        if (MeterConfig.printPosition) {
            stringBuilder.append('#');
            stringBuilder.append(this.position);
        }
        if (this.okPath != null) {
            stringBuilder.append(" [");
            stringBuilder.append(this.okPath);
            stringBuilder.append(']');
        }
        if (this.rejectPath != null) {
            stringBuilder.append(" [");
            stringBuilder.append(this.rejectPath);
            stringBuilder.append(']');
        }
        if (this.failPath != null || this.failMessage != null) {
            stringBuilder.append(" [");
            if (this.failPath != null) {
                stringBuilder.append(this.failPath);
            }
            if (this.failPath != null && this.failMessage != null) {
                stringBuilder.append("; ");
            }
            if (this.failMessage != null) {
                stringBuilder.append(this.failMessage);
            }
            stringBuilder.append(']');
        }
        if (this.startTime != 0L && this.currentIteration > 0L) {
            stringBuilder.append(' ');
            stringBuilder.append(UnitFormatter.iterations(this.currentIteration));
            if (this.expectedIterations > 0L) {
                stringBuilder.append('/');
                stringBuilder.append(UnitFormatter.iterations(this.expectedIterations));
            }
        }
        if (this.description != null) {
            stringBuilder.append(" '");
            stringBuilder.append(this.description);
            stringBuilder.append('\'');
        }
        if (this.context != null) {
            for (Map.Entry<String, String> entry : this.context.entrySet()) {
                stringBuilder.append("; ");
                stringBuilder.append(entry.getKey());
                if (entry.getValue() == null) continue;
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
            }
        }
        if (this.startTime != 0L) {
            long l = this.getExecutionTime();
            if (l > MeterConfig.progressPeriodMilliseconds) {
                stringBuilder.append("; ");
                stringBuilder.append(UnitFormatter.nanoseconds(l));
            }
            if (this.currentIteration > 0L) {
                stringBuilder.append("; ");
                double d = this.getIterationsPerSecond();
                stringBuilder.append(UnitFormatter.iterationsPerSecond(d));
                stringBuilder.append(' ');
                double d2 = 1.0 / d * 1.0E9;
                stringBuilder.append(UnitFormatter.nanoseconds(d2));
            }
        } else {
            stringBuilder.append("; ");
            stringBuilder.append(UnitFormatter.nanoseconds(this.getWaitingTime()));
        }
        if (MeterConfig.printMemory && this.runtime_usedMemory > 0L) {
            stringBuilder.append("; ");
            stringBuilder.append(UnitFormatter.bytes(this.runtime_usedMemory));
        }
        if (MeterConfig.printLoad && this.systemLoad > 0.0) {
            stringBuilder.append("; ");
            stringBuilder.append(Math.round(this.systemLoad * 100.0));
            stringBuilder.append("%");
        }
        if (SessionConfig.uuidSize != 0 && this.sessionUuid != null) {
            stringBuilder.append("; ");
            stringBuilder.append(this.sessionUuid.substring(32 - SessionConfig.uuidSize));
        }
        return stringBuilder;
    }

    @Override
    public void writePropertiesImpl(EventWriter eventWriter) {
        if (this.description != null) {
            eventWriter.property(PROP_DESCRIPTION, this.description);
        }
        if (this.rejectPath != null) {
            eventWriter.property(PROP_REJECT_ID, this.rejectPath);
        }
        if (this.okPath != null) {
            eventWriter.property(PROP_PATH_ID, this.okPath);
        }
        if (this.failPath != null) {
            eventWriter.property(PROP_FAIL_ID, this.failPath, this.failMessage != null ? this.failMessage : "");
        }
        if (this.category != null) {
            eventWriter.property(EVENT_CATEGORY, this.category);
        }
        if (this.operation != null) {
            eventWriter.property(EVENT_NAME, this.operation);
        }
        if (this.parent != null) {
            eventWriter.property(EVENT_PARENT, this.parent);
        }
        if (this.createTime != 0L) {
            eventWriter.property(PROP_CREATE_TIME, this.createTime);
        }
        if (this.startTime != 0L) {
            eventWriter.property(PROP_START_TIME, this.startTime);
        }
        if (this.stopTime != 0L) {
            eventWriter.property(PROP_STOP_TIME, this.stopTime);
        }
        if (this.currentIteration != 0L) {
            eventWriter.property(PROP_ITERATION, this.currentIteration);
        }
        if (this.expectedIterations != 0L) {
            eventWriter.property(PROP_EXPECTED_ITERATION, this.expectedIterations);
        }
        if (this.timeLimit != 0L) {
            eventWriter.property(PROP_LIMIT_TIME, this.timeLimit);
        }
        if (this.context != null && !this.context.isEmpty()) {
            eventWriter.property(PROP_CONTEXT, this.context);
        }
        super.writePropertiesImpl(eventWriter);
    }

    @Override
    protected boolean readPropertyImpl(EventReader eventReader, String string) throws IOException {
        if (PROP_DESCRIPTION.equals(string)) {
            this.description = eventReader.readString();
            return true;
        }
        if (EVENT_CATEGORY.equals(string)) {
            this.category = eventReader.readString();
            return true;
        }
        if (EVENT_NAME.equals(string)) {
            this.operation = eventReader.readString();
            return true;
        }
        if (EVENT_PARENT.equals(string)) {
            this.parent = eventReader.readString();
            return true;
        }
        if (PROP_FAIL_ID.equals(string)) {
            this.failPath = eventReader.readString();
            this.failMessage = eventReader.readString();
            return true;
        }
        if (PROP_REJECT_ID.equals(string)) {
            this.rejectPath = eventReader.readString();
            return true;
        }
        if (PROP_PATH_ID.equals(string)) {
            this.okPath = eventReader.readString();
            return true;
        }
        if (PROP_CREATE_TIME.equals(string)) {
            this.createTime = eventReader.readLong();
            return true;
        }
        if (PROP_START_TIME.equals(string)) {
            this.startTime = eventReader.readLong();
            return true;
        }
        if (PROP_STOP_TIME.equals(string)) {
            this.stopTime = eventReader.readLong();
            return true;
        }
        if (PROP_ITERATION.equals(string)) {
            this.currentIteration = eventReader.readLong();
            return true;
        }
        if (PROP_EXPECTED_ITERATION.equals(string)) {
            this.expectedIterations = eventReader.readLong();
            return true;
        }
        if (PROP_LIMIT_TIME.equals(string)) {
            this.timeLimit = eventReader.readLong();
            return true;
        }
        if (PROP_CONTEXT.equals(string)) {
            this.context = eventReader.readMap();
            return true;
        }
        return super.readPropertyImpl(eventReader, string);
    }

    public final boolean read(String string) {
        return this.read(string, 'M');
    }

    public final String write() {
        return this.write(new StringBuilder(), 'M').toString();
    }

    public final String readableWrite() {
        return this.readableString(new StringBuilder()).toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MeterData meterData = (MeterData)object;
        if (this.category != null ? !this.category.equals(meterData.category) : meterData.category != null) {
            return false;
        }
        if (this.sessionUuid != null ? !this.sessionUuid.equals(meterData.sessionUuid) : meterData.sessionUuid != null) {
            return false;
        }
        if (this.position != meterData.position) {
            return false;
        }
        return this.operation != null ? this.operation.equals(meterData.operation) : meterData.operation == null;
    }

    public int hashCode() {
        int n = this.category != null ? this.category.hashCode() : 0;
        n = 31 * n + (this.operation != null ? this.operation.hashCode() : 0);
        n = 31 * n + (int)(this.position ^ this.position >>> 32);
        n = 31 * n + (this.sessionUuid != null ? this.sessionUuid.hashCode() : 0);
        return n;
    }
}

