/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.meter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.usefultoys.slf4j.meter.MeterData;

public final class ToCSV {
    private ToCSV() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("ToCSV file.log [prefix] ");
            return;
        }
        String string = stringArray[0];
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            MeterData meterData = new MeterData();
            System.out.println("uuid,category,position,waiting,execution,success,slow");
            while ((string2 = bufferedReader.readLine()) != null) {
                boolean bl = meterData.read(string2);
                if (!bl) continue;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(meterData.getSessionUuid());
                stringBuilder.append(',');
                stringBuilder.append(meterData.getCategory());
                stringBuilder.append(',');
                stringBuilder.append(meterData.getPosition());
                stringBuilder.append(',');
                stringBuilder.append((double)meterData.getWaitingTime() / 1000000.0);
                stringBuilder.append(',');
                stringBuilder.append((double)meterData.getExecutionTime() / 1000000.0);
                stringBuilder.append(',');
                stringBuilder.append(meterData.isOK());
                stringBuilder.append(',');
                stringBuilder.append(meterData.isSlow());
                stringBuilder.append(',');
                System.out.println(stringBuilder);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
            }
        }
    }
}

