/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.report;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.usefultoys.slf4j.LoggerFactory;
import org.usefultoys.slf4j.report.ReporterConfig;
import org.usefultoys.slf4j.utils.UnitFormatter;

public class Reporter
implements Serializable {
    private final Logger logger;
    private static final long serialVersionUID = 1L;

    public Reporter() {
        this.logger = LoggerFactory.getLogger(ReporterConfig.name);
    }

    public Reporter(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void logAllReports(Executor executor) {
        executor.execute(new ReportPhysicalSystem());
        executor.execute(new ReportOperatingSystem());
        executor.execute(new ReportUser());
        executor.execute(new ReportVM());
        executor.execute(new ReportMemory());
        executor.execute(new ReportSystemEnvironment());
        executor.execute(new ReportSystemProperties());
        executor.execute(new ReportFileSystem());
        executor.execute(new ReportCalendar());
        executor.execute(new ReportLocale());
        executor.execute(new ReportCharset());
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                executor.execute(new ReportNetworkInterface(networkInterface));
            }
        }
        catch (SocketException socketException) {
            this.logger.warn("Cannot report interfaces.", (Throwable)socketException);
        }
    }

    public void logDefaultReports(Executor executor) {
        if (ReporterConfig.reportPhysicalSystem) {
            executor.execute(new ReportPhysicalSystem());
        }
        if (ReporterConfig.reportOperatingSystem) {
            executor.execute(new ReportOperatingSystem());
        }
        if (ReporterConfig.reportUser) {
            executor.execute(new ReportUser());
        }
        if (ReporterConfig.reportVM) {
            executor.execute(new ReportVM());
        }
        if (ReporterConfig.reportMemory) {
            executor.execute(new ReportMemory());
        }
        if (ReporterConfig.reportEnvironment) {
            executor.execute(new ReportSystemEnvironment());
        }
        if (ReporterConfig.reportProperties) {
            executor.execute(new ReportSystemProperties());
        }
        if (ReporterConfig.reportFileSystem) {
            executor.execute(new ReportFileSystem());
        }
        if (ReporterConfig.reportCalendar) {
            executor.execute(new ReportCalendar());
        }
        if (ReporterConfig.reportLocale) {
            executor.execute(new ReportLocale());
        }
        if (ReporterConfig.reportCharset) {
            executor.execute(new ReportCharset());
        }
        if (ReporterConfig.reportNetworkInterface) {
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    executor.execute(new ReportNetworkInterface(networkInterface));
                }
            }
            catch (SocketException socketException) {
                this.logger.warn("Cannot report interfaces", (Throwable)socketException);
            }
        }
    }

    public class ReportNetworkInterface
    implements Runnable {
        private final NetworkInterface nif;

        public ReportNetworkInterface(NetworkInterface networkInterface) {
            this.nif = networkInterface;
        }

        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            try {
                printStream.println("Network Interface " + this.nif.getName() + ":");
                printStream.println(" - display name: " + this.nif.getDisplayName());
                printStream.print(" - properties: ");
                printStream.print("mtu=" + this.nif.getMTU() + "; ");
                if (this.nif.isLoopback()) {
                    printStream.print("loopback; ");
                }
                if (this.nif.isPointToPoint()) {
                    printStream.print("point-to-point; ");
                }
                if (this.nif.isUp()) {
                    printStream.print("UP; ");
                }
                if (this.nif.isVirtual()) {
                    printStream.print("virtual; ");
                }
                if (this.nif.supportsMulticast()) {
                    printStream.print("multicast; ");
                }
                printStream.println();
                printStream.print(" - hardware address: ");
                byte[] byArray = this.nif.getHardwareAddress();
                if (byArray == null) {
                    printStream.println("n/a");
                } else {
                    for (byte by : byArray) {
                        printStream.print(String.format("%1$02X ", by));
                    }
                    printStream.println();
                }
                Object object = this.nif.getInetAddresses();
                while (object.hasMoreElements()) {
                    this.reportNetworkAddress(printStream, (InetAddress)object.nextElement());
                }
            }
            catch (IOException iOException) {
                printStream.println("   Cannot read property: " + iOException.getLocalizedMessage());
            }
            printStream.close();
        }

        private void reportNetworkAddress(PrintStream printStream, InetAddress inetAddress) {
            try {
                if (inetAddress instanceof Inet4Address) {
                    printStream.println(" - NET address (IPV4): " + inetAddress.getHostAddress());
                } else if (inetAddress instanceof Inet6Address) {
                    printStream.println(" - NET address (IPV6): " + inetAddress.getHostAddress());
                }
                printStream.println("      host name: " + inetAddress.getHostName());
                printStream.println("      canonical host name : " + inetAddress.getCanonicalHostName());
                printStream.print("      properties: ");
                if (inetAddress.isLoopbackAddress()) {
                    printStream.print("loopback; ");
                }
                if (inetAddress.isSiteLocalAddress()) {
                    printStream.print("site-local; ");
                }
                if (inetAddress.isAnyLocalAddress()) {
                    printStream.print("any-local; ");
                }
                if (inetAddress.isLinkLocalAddress()) {
                    printStream.print("link-local; ");
                }
                if (inetAddress.isMulticastAddress()) {
                    printStream.print("multicas; ");
                }
                if (inetAddress.isReachable(5000)) {
                    printStream.print("reachable; ");
                }
                printStream.println();
            }
            catch (IOException iOException) {
                printStream.println("   Cannot read property: " + iOException.getLocalizedMessage());
            }
        }
    }

    public class ReportCharset
    implements Runnable {
        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            Charset charset = Charset.defaultCharset();
            printStream.println("Charset");
            printStream.print(" - default charset: " + charset.displayName());
            printStream.print("; name=" + charset.name());
            printStream.print("; canEncode=" + charset.canEncode());
            printStream.println();
            printStream.print(" - available charsets: ");
            int n = 1;
            for (Charset charset2 : Charset.availableCharsets().values()) {
                if (n++ % 5 == 0) {
                    printStream.print("\n      ");
                }
                printStream.print(charset2.displayName() + "; ");
            }
            printStream.close();
        }
    }

    public class ReportLocale
    implements Runnable {
        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            Locale locale = Locale.getDefault();
            printStream.println("Locale");
            printStream.print(" - default locale: " + locale.getDisplayName());
            printStream.print("; language=" + locale.getDisplayLanguage() + " (" + locale.getLanguage() + ")");
            printStream.print("; country=" + locale.getDisplayCountry() + " (" + locale.getCountry() + ")");
            try {
                printStream.print("; script=" + locale.getDisplayScript() + " (" + locale.getScript() + ")");
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            printStream.print("; variant=" + locale.getDisplayVariant() + " (" + locale.getVariant() + ")");
            printStream.println();
            printStream.print(" - available locales: ");
            int n = 1;
            for (Locale locale2 : Locale.getAvailableLocales()) {
                if (n++ % 5 == 0) {
                    printStream.print("\n      ");
                }
                printStream.print(locale2.getDisplayName() + "; ");
            }
            printStream.close();
        }
    }

    public class ReportCalendar
    implements Runnable {
        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            printStream.println("Calendar");
            printStream.print(" - current date/time: " + DateFormat.getDateTimeInstance().format(new Date()));
            TimeZone timeZone = TimeZone.getDefault();
            printStream.print(" - default timezone: " + timeZone.getDisplayName());
            printStream.print(" (" + timeZone.getID() + ")");
            printStream.print("; DST=" + timeZone.getDSTSavings() / 60000 + "min");
            try {
                printStream.print("; observesDT=" + timeZone.observesDaylightTime());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            printStream.print("; useDT=" + timeZone.useDaylightTime());
            printStream.print("; inDT=" + timeZone.inDaylightTime(new Date()));
            printStream.print("; offset=" + timeZone.getRawOffset() / 60000 + "min");
            printStream.println();
            printStream.print(" - available IDs: ");
            int n = 1;
            for (String string : TimeZone.getAvailableIDs()) {
                if (n++ % 5 == 0) {
                    printStream.print("\n      ");
                }
                printStream.print(string + "; ");
            }
            printStream.close();
        }
    }

    public class ReportOperatingSystem
    implements Runnable {
        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            printStream.println("Operating System");
            printStream.println(" - architecture: " + System.getProperty("os.arch"));
            printStream.println(" - name: " + System.getProperty("os.name"));
            printStream.println(" - version: " + System.getProperty("os.version"));
            printStream.println(" - file separator: " + Integer.toHexString(System.getProperty("file.separator").charAt(0)));
            printStream.println(" - path separator: " + Integer.toHexString(System.getProperty("path.separator").charAt(0)));
            printStream.println(" - line separator: " + Integer.toHexString(System.getProperty("line.separator").charAt(0)));
            printStream.close();
        }
    }

    public class ReportPhysicalSystem
    implements Runnable {
        @Override
        public void run() {
            Runtime runtime = Runtime.getRuntime();
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            printStream.println("Physical system");
            printStream.println(" - processors: " + runtime.availableProcessors());
            printStream.close();
        }
    }

    public class ReportSystemProperties
    implements Runnable {
        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            printStream.println("System Properties:");
            Properties properties = System.getProperties();
            for (Map.Entry entry : properties.entrySet()) {
                printStream.println(" - " + entry.getKey() + ": " + entry.getValue());
            }
            printStream.close();
        }
    }

    public class ReportSystemEnvironment
    implements Runnable {
        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            printStream.println("System Environment:");
            Map<String, String> map = System.getenv();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                printStream.println(" - " + entry.getKey() + ": " + entry.getValue());
            }
            printStream.close();
        }
    }

    public class ReportUser
    implements Runnable {
        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            printStream.println("User:");
            printStream.println(" - name: " + System.getProperty("user.name"));
            printStream.println(" - home: " + System.getProperty("user.home"));
            printStream.close();
        }
    }

    public class ReportMemory
    implements Runnable {
        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            Runtime runtime = Runtime.getRuntime();
            printStream.println("Memory:");
            long l = runtime.maxMemory();
            long l2 = runtime.totalMemory();
            long l3 = runtime.freeMemory();
            printStream.println(" - maximum allowed: " + (l == Long.MAX_VALUE ? "no limit" : UnitFormatter.bytes(l)));
            printStream.println(" - currently allocated: " + UnitFormatter.bytes(l2) + " (" + UnitFormatter.bytes(l - l2) + " more available)");
            printStream.println(" - currently used: " + UnitFormatter.bytes(l2 - l3) + " (" + UnitFormatter.bytes(l3) + " free)");
            printStream.close();
        }
    }

    public class ReportFileSystem
    implements Runnable {
        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            File[] fileArray = File.listRoots();
            boolean bl = true;
            for (File file : fileArray) {
                if (bl) {
                    bl = false;
                } else {
                    printStream.println();
                }
                printStream.println("File system root: " + file.getAbsolutePath());
                printStream.println(" - total space: " + UnitFormatter.bytes(file.getTotalSpace()));
                printStream.println(" - currently free space: " + UnitFormatter.bytes(file.getFreeSpace()) + " (" + UnitFormatter.bytes(file.getUsableSpace()) + " usable)");
            }
            printStream.close();
        }
    }

    public class ReportVM
    implements Runnable {
        @Override
        public void run() {
            PrintStream printStream = LoggerFactory.getInfoPrintStream(Reporter.this.logger);
            printStream.println("Java Virtual Machine");
            printStream.println(" - vendor: " + System.getProperty("java.vendor"));
            printStream.println(" - version: " + System.getProperty("java.version"));
            printStream.println(" - installation directory: " + System.getProperty("java.home"));
            printStream.close();
        }
    }
}

