/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.utils;

public final class UnitFormatter {
    private static final int[] TIME_FACTORS = new int[]{1000, 1000, 1000, 60, 60};
    private static final String[] TIME_UNITS = new String[]{"ns", "us", "ms", "s", "m", "h"};
    private static final String[] MEMORY_UNITS = new String[]{"B", "kB", "MB", "GB"};
    private static final int[] MEMORY_FACTORS = new int[]{1000, 1000, 1000};
    private static final String[] ITERATIONS_PER_TIME_UNITS = new String[]{"/s", "k/s", "M/s"};
    private static final int[] ITERATIONS_PER_TIME_FACTORS = new int[]{1000, 1000, 1000};
    private static final String[] ITERATIONS_UNITS = new String[]{"", "k", "M"};
    private static final int[] ITERATIONS_FACTORS = new int[]{1000, 1000, 1000};
    static final double Epsylon = 0.001;

    private UnitFormatter() {
    }

    static String longUnit(long l, String[] stringArray, int[] nArray) {
        int n = 0;
        int n2 = nArray[n] + nArray[n] / 10;
        if (l < (long)n2) {
            return String.format("%d%s", l, stringArray[n]);
        }
        int n3 = nArray.length;
        double d = l;
        while (n < n3 && l >= (long)(nArray[n] + nArray[n] / 10)) {
            d = (double)l / (double)nArray[n];
            l /= (long)nArray[n];
            ++n;
        }
        return String.format("%.1f%s", d, stringArray[n]);
    }

    static String doubleUnit(double d, String[] stringArray, int[] nArray) {
        int n;
        if (d == 0.0) {
            return "0" + stringArray[0];
        }
        int n2 = nArray.length;
        for (n = 0; n < n2 && d + 0.001 >= (double)nArray[n] + (double)nArray[n] / 10.0; ++n) {
            d /= (double)nArray[n];
        }
        return String.format("%.1f%s", d, stringArray[n]);
    }

    public static String bytes(long l) {
        return UnitFormatter.longUnit(l, MEMORY_UNITS, MEMORY_FACTORS);
    }

    public static String nanoseconds(long l) {
        return UnitFormatter.longUnit(l, TIME_UNITS, TIME_FACTORS);
    }

    public static String nanoseconds(double d) {
        return UnitFormatter.doubleUnit(d, TIME_UNITS, TIME_FACTORS);
    }

    public static String iterations(long l) {
        return UnitFormatter.longUnit(l, ITERATIONS_UNITS, ITERATIONS_FACTORS);
    }

    public static String iterations(double d) {
        return UnitFormatter.doubleUnit(d, ITERATIONS_UNITS, ITERATIONS_FACTORS);
    }

    public static String iterationsPerSecond(long l) {
        return UnitFormatter.longUnit(l, ITERATIONS_PER_TIME_UNITS, ITERATIONS_PER_TIME_FACTORS);
    }

    public static String iterationsPerSecond(double d) {
        return UnitFormatter.doubleUnit(d, ITERATIONS_PER_TIME_UNITS, ITERATIONS_PER_TIME_FACTORS);
    }
}

